/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.SendNotesPartToServerPacket;

public class MusicManager {
    public static Map<UUID, TempNotesBuffer> TEMP_NOTES_MAP = new HashMap<UUID, TempNotesBuffer>();

    public static MusicData getMusicData(UUID id, int ver, MinecraftServer server) {
        SavedDataMusic savedDataMusic = (SavedDataMusic)server.m_129783_().m_8895_().m_164861_(SavedDataMusic::load, SavedDataMusic::new, "music_map");
        Map<UUID, MusicData> musicMap = savedDataMusic.getMusicMap();
        if (musicMap.containsKey(id)) {
            MusicData data = musicMap.get(id);
            if (data.version >= ver) {
                XercaMusic.LOGGER.debug("Music data found in server (id: {}, ver: {}) (getMusicData)", (Object)id, (Object)ver);
                return data;
            }
            XercaMusic.LOGGER.debug("Music data in server is too old (id: {}, data ver: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)data.version, (Object)ver);
        } else {
            XercaMusic.LOGGER.debug("Music data not found in server (id: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)ver);
        }
        return null;
    }

    public static void setMusicData(UUID id, int ver, ArrayList<NoteEvent> notes, MinecraftServer server) {
        SavedDataMusic savedDataMusic = (SavedDataMusic)server.m_129783_().m_8895_().m_164861_(SavedDataMusic::load, SavedDataMusic::new, "music_map");
        Map<UUID, MusicData> musicMap = savedDataMusic.getMusicMap();
        musicMap.put(id, new MusicData(ver, notes));
        savedDataMusic.m_77762_();
    }

    public static ArrayList<NoteEvent> getFinishedNotesFromBuffer(UUID id) {
        if (TEMP_NOTES_MAP.containsKey(id)) {
            TempNotesBuffer buffer = TEMP_NOTES_MAP.get(id);
            if (buffer.isFinished()) {
                return buffer.joinParts();
            }
            XercaMusic.LOGGER.warn("Packet did not have notes, and temp buffer was not finished");
        } else {
            XercaMusic.LOGGER.warn("Packet did not have notes, and temp buffer was not found");
        }
        return null;
    }

    public static boolean addNotesPart(SendNotesPartToServerPacket pkt) {
        TempNotesBuffer buffer;
        if (TEMP_NOTES_MAP.containsKey(pkt.getUuid())) {
            buffer = TEMP_NOTES_MAP.get(pkt.getUuid());
            buffer.addPart(pkt.getPartId(), pkt.getNotes());
        } else {
            buffer = new TempNotesBuffer(pkt.getPartsCount());
            buffer.addPart(pkt.getPartId(), pkt.getNotes());
            TEMP_NOTES_MAP.put(pkt.getUuid(), buffer);
        }
        return buffer.isFinished();
    }

    public static class SavedDataMusic
    extends SavedData {
        private final Map<UUID, MusicData> musicMap;

        private SavedDataMusic(Map<UUID, MusicData> musicMap) {
            this.musicMap = musicMap;
        }

        public SavedDataMusic() {
            this(new HashMap<UUID, MusicData>());
        }

        public static SavedDataMusic load(CompoundTag tag) {
            Tag musicTag = tag.m_128423_("MusicDataList");
            if (musicTag instanceof ListTag) {
                ListTag musicDataList = (ListTag)musicTag;
                HashMap<UUID, MusicData> musicDataMap = new HashMap<UUID, MusicData>();
                for (Tag nbt : musicDataList) {
                    if (!(nbt instanceof CompoundTag)) continue;
                    CompoundTag musicData = (CompoundTag)nbt;
                    ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
                    NoteEvent.fillArrayFromNBT(notes, musicData);
                    musicDataMap.put(musicData.m_128342_("id"), new MusicData(musicData.m_128451_("ver"), notes));
                }
                return new SavedDataMusic(musicDataMap);
            }
            return new SavedDataMusic();
        }

        @NotNull
        public CompoundTag m_7176_(@NotNull CompoundTag tag) {
            ListTag musicDataList = new ListTag();
            for (Map.Entry<UUID, MusicData> entry : this.musicMap.entrySet()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128362_("id", entry.getKey());
                nbt.m_128405_("ver", entry.getValue().version);
                NoteEvent.fillNBTFromArray(entry.getValue().notes, nbt);
                musicDataList.add((Object)nbt);
            }
            tag.m_128365_("MusicDataList", (Tag)musicDataList);
            return tag;
        }

        public Map<UUID, MusicData> getMusicMap() {
            return this.musicMap;
        }
    }

    public static class MusicData {
        public final int version;
        public final ArrayList<NoteEvent> notes;

        public MusicData(int version, ArrayList<NoteEvent> notes) {
            this.version = version;
            this.notes = notes;
        }
    }

    public static class TempNotesBuffer {
        int partsCount;
        boolean[] finishedParts;
        List<NoteEvent>[] notesParts;

        public TempNotesBuffer(int partsCount) {
            this.partsCount = partsCount;
            this.finishedParts = new boolean[partsCount];
            this.notesParts = new ArrayList[partsCount];
        }

        public void addPart(int partId, List<NoteEvent> part) {
            if (partId < this.partsCount && partId >= 0) {
                this.notesParts[partId] = part;
                this.finishedParts[partId] = true;
            }
        }

        public boolean isFinished() {
            boolean result = true;
            for (boolean f : this.finishedParts) {
                result &= f;
            }
            return result;
        }

        public ArrayList<NoteEvent> joinParts() {
            ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>(this.partsCount * 5000);
            for (List<NoteEvent> notesPart : this.notesParts) {
                notes.addAll(notesPart);
            }
            return notes;
        }
    }
}

