/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.dryingbasin;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamicscompat.modcompat.common.JeiReiHelpers;
import org.cyclops.integrateddynamicscompat.modcompat.jei.dryingbasin.DryingBasinRecipeJEI;

public class DryingBasinRecipeCategory
implements IRecipeCategory<DryingBasinRecipeJEI> {
    public static final RecipeType<DryingBasinRecipeJEI> TYPE = RecipeType.create((String)"integrateddynamicscompat", (String)"drying_basin", DryingBasinRecipeJEI.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public DryingBasinRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat", "textures/gui/drying_basin_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 93, 53);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_DRYING_BASIN));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 94, 0, 11, 28);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public RecipeType<DryingBasinRecipeJEI> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)RegistryEntries.BLOCK_DRYING_BASIN.m_7705_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingBasinRecipeJEI recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 8).addItemStacks(recipe.getInputItem());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 8).addItemStack(recipe.getOutputItem());
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 28).setFluidRenderer(1000L, true, 8, 9).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getInputFluid());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 28).setFluidRenderer(1000L, true, 8, 9).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
    }

    public void draw(DryingBasinRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 43, 11);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent duration = JeiReiHelpers.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.m_272077_((Component)duration, (float)((this.background.getWidth() - fontRenderer.m_92852_((FormattedText)duration)) / 2 + 3), 42.0f, -8355712, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

