/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;

public class ItemEnhancement
extends Item {
    private final Type type;

    public ItemEnhancement(Type type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public <P extends IPartType<P, S>, S extends IPartState<P>> InteractionResult applyEnhancement(IPartType<P, S> partType, IPartState<P> partState, ItemStack itemStack, Player player, InteractionHand hand) {
        switch (this.type) {
            case OFFSET: {
                if (!partType.supportsOffsets()) break;
                int value = this.getEnhancementValue(itemStack);
                int newValue = partState.getMaxOffset() + value;
                if (newValue <= GeneralConfig.maxPartOffset) {
                    if (!player.m_9236_().m_5776_()) {
                        partState.setMaxOffset(newValue);
                        itemStack.m_41774_(1);
                        player.m_5661_((Component)Component.m_237110_((String)"item.integrateddynamics.enhancement_offset.increased", (Object[])new Object[]{newValue}), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Component.m_237110_((String)"item.integrateddynamics.enhancement_offset.limit", (Object[])new Object[]{GeneralConfig.maxPartOffset}), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public int getEnhancementValue(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("value");
    }

    public void setEnhancementValue(ItemStack itemStack, int value) {
        itemStack.m_41784_().m_128405_("value", value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237110_((String)"item.integrateddynamics.enhancement_offset.tooltip", (Object[])new Object[]{this.getEnhancementValue(itemStack)}).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(itemStack, world, list, flag);
    }

    public static enum Type {
        OFFSET;

    }
}

