/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class NetworkDiagnosticsPartOverlayRenderer {
    private static final NetworkDiagnosticsPartOverlayRenderer _INSTANCE = new NetworkDiagnosticsPartOverlayRenderer();
    private final Set<PartPos> partPositions = Sets.newHashSet();

    private NetworkDiagnosticsPartOverlayRenderer() {
    }

    public static NetworkDiagnosticsPartOverlayRenderer getInstance() {
        return _INSTANCE;
    }

    public synchronized void addPos(PartPos pos) {
        this.partPositions.add(pos);
    }

    public synchronized void removePos(PartPos pos) {
        this.partPositions.remove(pos);
    }

    public synchronized void clearPositions() {
        this.partPositions.clear();
    }

    public synchronized boolean hasPartPos(PartPos pos) {
        return this.partPositions.contains(pos);
    }

    @SubscribeEvent
    public void onRender(RenderLevelStageEvent event) {
        if (!this.partPositions.isEmpty() && event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Vec3 eyePos = event.getCamera().m_90583_();
            double offsetX = eyePos.f_82479_;
            double offsetY = eyePos.f_82480_;
            double offsetZ = eyePos.f_82481_;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.lineWidth((float)6.0f);
            RenderSystem.depthMask((boolean)false);
            ArrayList partList = Lists.newArrayList(this.partPositions);
            for (PartPos partPos : partList) {
                if (!partPos.getPos().getLevelKey().m_135782_().equals((Object)player.m_9236_().m_46472_().m_135782_()) || !(partPos.getPos().getBlockPos().m_123331_((Vec3i)player.m_20183_()) < 10000.0)) continue;
                PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
                VoxelShape shape = partStateHolder != null ? partStateHolder.getPart().getPartRenderPosition().getBoundingBox(partPos.getSide()) : Shapes.f_83037_;
                AABB bb = shape.m_83215_().m_82338_(partPos.getPos().getBlockPos()).m_82386_(-offsetX, -offsetY, -offsetZ).m_82377_(0.05, 0.05, 0.05).m_82377_(-0.05, -0.05, -0.05);
                LevelRenderer.m_109646_((PoseStack)event.getPoseStack(), (VertexConsumer)Minecraft.m_91087_().m_91269_().m_110109_().m_6299_(RenderType.m_110504_()), (AABB)bb, (float)1.0f, (float)0.2f, (float)0.1f, (float)0.8f);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }
}

