/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapter;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetworkIngredients;

public class IngredientChannelPositioned<T, M>
extends IngredientChannelAdapter<T, M> {
    public IngredientChannelPositioned(PositionedAddonsNetworkIngredients<T, M> network, int channel) {
        super(network, channel);
    }

    @Override
    protected Iterator<PartPos> getNonFullPositions() {
        return this.getAllPositions();
    }

    @Override
    protected Iterator<PartPos> getAllPositions() {
        this.scheduleObservation();
        return this.getNetwork().getPositions(this.getChannel()).iterator();
    }

    @Override
    protected Iterator<PartPos> getNonEmptyPositions() {
        return this.getAllPositions();
    }

    @Override
    protected Iterator<PartPos> getMatchingPositions(@Nonnull T prototype, M matchFlags) {
        return this.getAllPositions();
    }

    public Iterator<T> iterator() {
        this.scheduleObservation();
        return new PositionedIngredientIterator<Object, Object>(this.getNetwork(), this.getNetwork().getPositions(this.getChannel()).iterator(), this.getComponent().getMatcher().getEmptyInstance(), this.getComponent().getMatcher().getAnyMatchCondition());
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchFlags) {
        this.scheduleObservation();
        return new PositionedIngredientIterator(this.getNetwork(), this.getNetwork().getPositions(this.getChannel()).iterator(), prototype, matchFlags);
    }

    public static class PositionedIngredientIterator<T, M>
    implements Iterator<T> {
        private final IPositionedAddonsNetworkIngredients<T, M> network;
        private final Iterator<PartPos> it;
        private final T prototype;
        private final M matchFlags;
        private Iterator<T> lastPos;

        public PositionedIngredientIterator(IPositionedAddonsNetworkIngredients<T, M> network, Iterator<PartPos> it, T prototype, M matchFlags) {
            this.network = network;
            this.it = it;
            this.prototype = prototype;
            this.matchFlags = matchFlags;
            this.prepareLastPos();
        }

        protected void prepareLastPos() {
            do {
                if (this.it.hasNext()) {
                    PartPos pos = this.it.next();
                    if (!pos.getPos().isLoaded()) continue;
                    this.lastPos = this.network.getPositionedStorage(pos).iterator(this.prototype, this.matchFlags);
                    PositionedAddonsNetworkIngredientsFilter<T> filter = this.network.getPositionedStorageFilter(pos);
                    if (filter == null) continue;
                    this.lastPos = Iterators.filter(this.lastPos, filter::testView);
                    continue;
                }
                this.lastPos = null;
            } while (this.lastPos != null && !this.lastPos.hasNext());
        }

        @Override
        public boolean hasNext() {
            return this.lastPos != null;
        }

        @Override
        public T next() {
            T next = this.lastPos.next();
            if (!this.lastPos.hasNext()) {
                this.prepareLastPos();
            }
            return next;
        }
    }
}

