/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;

public class VoxelShapeComponents
extends VoxelShape
implements Iterable<VoxelShape> {
    private final Collection<Pair<VoxelShape, IComponent>> entries;
    private final String stateId;

    protected VoxelShapeComponents(Collection<Pair<VoxelShape, IComponent>> entries, String stateId) {
        super(VoxelShapeComponents.createInnerPart(entries));
        this.entries = entries;
        this.stateId = stateId;
    }

    protected static DiscreteVoxelShape createInnerPart(Collection<Pair<VoxelShape, IComponent>> entries) {
        return new Part(entries.stream().map(pair -> ((VoxelShape)pair.getLeft()).f_83211_).collect(Collectors.toList()));
    }

    public static VoxelShapeComponents create(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext, List<IComponent> components) {
        ArrayList entries = Lists.newArrayList();
        for (IComponent component : components) {
            VoxelShape shape = component.getShape(blockState, world, blockPos, selectionContext);
            entries.add(Pair.of((Object)shape, (Object)component));
        }
        StringBuilder stateIdBuilder = new StringBuilder();
        for (IComponent component : components) {
            stateIdBuilder.append(component.getStateId(blockState, world, blockPos));
            stateIdBuilder.append(";");
        }
        return new VoxelShapeComponents(entries, stateIdBuilder.toString());
    }

    public String getStateId() {
        return this.stateId;
    }

    @Override
    public Iterator<VoxelShape> iterator() {
        return this.entries.stream().map(Pair::getLeft).iterator();
    }

    public double m_83288_(Direction.Axis axis) {
        boolean first = true;
        double startMin = 0.0;
        for (VoxelShape shape : this) {
            double start = shape.m_83288_(axis);
            if (!first && !(start < startMin)) continue;
            startMin = start;
            first = false;
        }
        return startMin;
    }

    public double m_83297_(Direction.Axis axis) {
        boolean first = true;
        double endMax = 0.0;
        for (VoxelShape shape : this) {
            double end = shape.m_83297_(axis);
            if (!first && !(end > endMax)) continue;
            endMax = end;
            first = false;
        }
        return endMax;
    }

    public DoubleList m_7700_(Direction.Axis axis) {
        DoubleArrayList values = new DoubleArrayList();
        for (VoxelShape shape : this) {
            values.addAll(shape.m_7700_(axis));
        }
        return values;
    }

    public boolean m_83281_() {
        for (VoxelShape shape : this) {
            if (shape.m_83281_()) continue;
            return false;
        }
        return true;
    }

    public VoxelShape m_83216_(double x, double y, double z) {
        ArrayList entries = Lists.newArrayList();
        for (Pair<VoxelShape, IComponent> entry : this.entries) {
            entries.add(Pair.of((Object)((VoxelShape)entry.getLeft()).m_83216_(x, y, z), (Object)((IComponent)entry.getRight())));
        }
        return new VoxelShapeComponents(entries, this.stateId);
    }

    public void m_83224_(Shapes.DoubleLineConsumer consumer) {
        for (VoxelShape shape : this) {
            shape.m_83224_(consumer);
        }
    }

    public void m_83286_(Shapes.DoubleLineConsumer consumer) {
        for (VoxelShape shape : this) {
            shape.m_83286_(consumer);
        }
    }

    public double m_83290_(Direction.Axis axis, double a, double b) {
        boolean first = true;
        double valueMax = 0.0;
        for (VoxelShape shape : this) {
            double value = shape.m_83290_(axis, a, b);
            if (!first && !(value > valueMax)) continue;
            valueMax = value;
            first = false;
        }
        return valueMax;
    }

    @Nullable
    public BlockRayTraceResultComponent clip(Vec3 startVec, Vec3 endVec, BlockPos pos) {
        double distanceMin = Double.POSITIVE_INFINITY;
        IComponent componentMin = null;
        BlockHitResult resultMin = null;
        for (Pair<VoxelShape, IComponent> entry : this.entries) {
            double distance;
            VoxelShape shape = (VoxelShape)entry.getLeft();
            BlockHitResult result = shape.m_83220_(startVec, endVec, pos);
            if (result == null || !((distance = result.m_82450_().m_82557_(startVec)) < distanceMin) || resultMin != null && ((IComponent)entry.getRight()).isRaytraceLastForFace() && componentMin.getRaytraceDirection() == result.m_82434_()) continue;
            distanceMin = distance;
            componentMin = (IComponent)entry.getRight();
            resultMin = result;
        }
        if (resultMin != null) {
            return new BlockRayTraceResultComponent(resultMin, componentMin);
        }
        return null;
    }

    @Nullable
    public BlockRayTraceResultComponent rayTrace(BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        AttributeInstance reachDistanceAttribute = entity instanceof LivingEntity ? ((LivingEntity)entity).m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()) : null;
        double reachDistance = reachDistanceAttribute == null ? 5.0 : reachDistanceAttribute.m_22135_();
        double eyeHeight = entity.m_20193_().m_5776_() ? (double)entity.m_20192_() : (double)entity.m_20192_();
        Vec3 lookVec = entity.m_20154_();
        Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20186_() + eyeHeight, entity.m_20189_());
        Vec3 direction = origin.m_82520_(lookVec.f_82479_ * reachDistance, lookVec.f_82480_ * reachDistance, lookVec.f_82481_ * reachDistance);
        return this.clip(origin, direction, pos);
    }

    public double m_83245_(AxisCycle rotation, AABB axisAlignedBB, double range) {
        boolean first = true;
        double valueBest = 0.0;
        for (VoxelShape shape : this) {
            double value = shape.m_83245_(rotation, axisAlignedBB, range);
            if (range > 0.0) {
                if (!first && !(value < valueBest)) continue;
                valueBest = value;
                first = false;
                continue;
            }
            if (!first && !(value > valueBest)) continue;
            valueBest = value;
            first = false;
        }
        return valueBest;
    }

    public static class Part
    extends DiscreteVoxelShape
    implements Iterable<DiscreteVoxelShape> {
        private final Collection<DiscreteVoxelShape> entries;

        public Part(Collection<DiscreteVoxelShape> entries) {
            super(0, 0, 0);
            this.entries = entries;
        }

        @Override
        public Iterator<DiscreteVoxelShape> iterator() {
            return this.entries.iterator();
        }

        public boolean m_82846_(int x, int y, int z) {
            for (DiscreteVoxelShape part : this) {
                if (!part.m_82846_(x, y, z)) continue;
                return true;
            }
            return false;
        }

        public boolean m_6696_(int x, int y, int z) {
            for (DiscreteVoxelShape part : this) {
                if (!part.m_6696_(x, y, z)) continue;
                return true;
            }
            return false;
        }

        public void m_142703_(int x, int y, int z) {
            for (DiscreteVoxelShape part : this) {
                part.m_142703_(x, y, z);
            }
        }

        public int m_6538_(Direction.Axis axis) {
            boolean first = true;
            int startMin = 0;
            for (DiscreteVoxelShape part : this) {
                int start = part.m_6538_(axis);
                if (!first && start >= startMin) continue;
                startMin = start;
                first = false;
            }
            return startMin;
        }

        public int m_6536_(Direction.Axis axis) {
            boolean first = true;
            int endMax = 0;
            for (DiscreteVoxelShape part : this) {
                int end = part.m_6536_(axis);
                if (!first && end <= endMax) continue;
                endMax = end;
                first = false;
            }
            return endMax;
        }

        public int m_82850_(Direction.Axis axis) {
            boolean first = true;
            int sizeMax = 0;
            for (DiscreteVoxelShape part : this) {
                int size = part.m_82850_(axis);
                if (!first && size <= sizeMax) continue;
                sizeMax = size;
                first = false;
            }
            return sizeMax;
        }

        public void m_82832_(DiscreteVoxelShape.IntLineConsumer consumer, boolean p_197831_2_) {
            for (DiscreteVoxelShape part : this) {
                part.m_82832_(consumer, p_197831_2_);
            }
        }
    }

    public static interface IComponent {
        public String getStateId(BlockState var1, BlockGetter var2, BlockPos var3);

        public VoxelShape getShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

        public ItemStack getCloneItemStack(Level var1, BlockPos var2);

        public boolean destroy(Level var1, BlockPos var2, Player var3, boolean var4);

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public BakedModel getBreakingBaseModel(Level var1, BlockPos var2);

        public InteractionResult onBlockActivated(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockRayTraceResultComponent var6);

        @Nullable
        public Direction getRaytraceDirection();

        public boolean isRaytraceLastForFace();
    }
}

