/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.type.InventoryFluid;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class BlockEntityDryingBasin
extends CyclopsBlockEntity {
    private static final int WOOD_IGNITION_TEMPERATURE = 573;
    private final SimpleInventory inventory;
    private final SingleUseTank tank;
    @NBTPersist
    private Float randomRotation = Float.valueOf(0.0f);
    @NBTPersist
    private int progress = 0;
    @NBTPersist
    private int fire = 0;
    private SingleCache<Pair<ItemStack, FluidStack>, Optional<RecipeDryingBasin>> recipeCache;

    public BlockEntityDryingBasin(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_DRYING_BASIN, blockPos, blockState);
        this.inventory = new SimpleInventory(1, 1){

            public boolean m_7013_(int i, ItemStack itemstack) {
                return this.m_8020_(0).m_41619_();
            }

            public void m_6836_(int slotId, ItemStack itemstack) {
                super.m_6836_(slotId, itemstack);
                BlockEntityDryingBasin.this.randomRotation = Float.valueOf(((BlockEntityDryingBasin)BlockEntityDryingBasin.this).f_58857_.f_46441_.m_188501_() * 360.0f);
                BlockEntityDryingBasin.this.sendUpdate();
            }
        };
        this.tank = new SingleUseTank(1000);
        this.addCapabilityInternal(ForgeCapabilities.ITEM_HANDLER, LazyOptional.of(() -> ((SimpleInventory)this.getInventory()).getItemHandler()));
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, LazyOptional.of(() -> new SimpleInventoryState(this.getInventory())));
        this.addCapabilityInternal(ForgeCapabilities.FLUID_HANDLER, LazyOptional.of(this::getTank));
        this.inventory.addDirtyMarkListener(() -> ((BlockEntityDryingBasin)this).sendUpdate());
        this.tank.addDirtyMarkListener(() -> ((SimpleInventory)this.inventory).m_6596_());
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeDryingBasin>>(){

            public Optional<RecipeDryingBasin> getNewValue(Pair<ItemStack, FluidStack> key) {
                InventoryFluid recipeInput = new InventoryFluid(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), NonNullList.m_122783_((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{(FluidStack)key.getRight()}));
                return CraftingHelpers.findServerRecipe(BlockEntityDryingBasin.this.getRegistry(), (Container)recipeInput, (Level)BlockEntityDryingBasin.this.m_58904_());
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.m_41728_((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight())) && FluidHelpers.getAmount((FluidStack)((FluidStack)cacheKey.getRight())) == FluidHelpers.getAmount((FluidStack)((FluidStack)newKey.getRight()));
            }
        });
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerDryingBasin<RecipeDryingBasin>(() -> ((BlockEntityDryingBasin)this).m_58904_(), RegistryEntries.RECIPETYPE_DRYING_BASIN)));
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getFire() {
        return this.fire;
    }

    public void setFire(int fire) {
        this.fire = fire;
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void read(CompoundTag tag) {
        this.inventory.readFromNBT(tag, "inventory");
        this.tank.readFromNBT(tag, "tank");
        super.read(tag);
    }

    public void m_183515_(CompoundTag tag) {
        this.inventory.writeToNBT(tag, "inventory");
        this.tank.writeToNBT(tag, "tank");
        super.m_183515_(tag);
    }

    protected RecipeType<RecipeDryingBasin> getRegistry() {
        return RegistryEntries.RECIPETYPE_DRYING_BASIN;
    }

    public Optional<RecipeDryingBasin> getCurrentRecipe() {
        return (Optional)this.recipeCache.get((Object)Pair.of((Object)this.getInventory().m_8020_(0).m_41777_(), (Object)FluidHelpers.copy((FluidStack)this.getTank().getFluid())));
    }

    public float getRandomRotation() {
        return this.randomRotation.floatValue();
    }

    public static class TickerClient
    implements BlockEntityTicker<BlockEntityDryingBasin> {
        public void tick(Level level, BlockPos pos, BlockState blockState, BlockEntityDryingBasin blockEntity) {
            if (blockEntity.getProgress() > 0 && level.f_46441_.m_188503_(5) == 0) {
                BlockState blockStateFluid;
                if (!blockEntity.getTank().isEmpty() && (blockStateFluid = blockEntity.getTank().getFluid().getFluid().getFluidType().getBlockForFluidState((BlockAndTintGetter)level, pos, blockEntity.getTank().getFluid().getFluid().m_76145_())) != null) {
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, blockStateFluid), (double)pos.m_123341_() + Math.random() * 0.8 + 0.1, (double)pos.m_123342_() + Math.random() * 0.1 + 0.9, (double)pos.m_123343_() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0);
                }
                if (!blockEntity.getInventory().m_8020_(0).m_41619_()) {
                    ItemStack itemStack = blockEntity.getInventory().m_8020_(0);
                    level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), (double)pos.m_123341_() + Math.random() * 0.8 + 0.1, (double)pos.m_123342_() + Math.random() * 0.1 + 0.9, (double)pos.m_123343_() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityDryingBasin> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityDryingBasin blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            Optional<RecipeDryingBasin> currentRecipe = blockEntity.getCurrentRecipe();
            if (!blockEntity.getTank().isEmpty() && blockEntity.getTank().getFluid().getFluid().getFluidType().getTemperature(blockEntity.getTank().getFluid()) >= 573) {
                blockEntity.setFire(blockEntity.getFire() + 1);
                if (blockEntity.getFire() >= 100) {
                    level.m_46597_(pos, Blocks.f_50083_.m_49966_());
                } else if (level.m_46859_(pos.m_121945_(Direction.UP)) && level.f_46441_.m_188503_(10) == 0) {
                    level.m_46597_(pos.m_121945_(Direction.UP), Blocks.f_50083_.m_49966_());
                }
            } else if (currentRecipe.isPresent()) {
                RecipeDryingBasin recipe = currentRecipe.get();
                if (blockEntity.getProgress() >= recipe.getDuration()) {
                    int amount = FluidHelpers.getAmount((FluidStack)recipe.getInputFluid());
                    blockEntity.getTank().drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack output = recipe.getOutputItemFirst();
                    if (!output.m_41619_()) {
                        output = output.m_41777_();
                        blockEntity.getInventory().m_6836_(0, output);
                    } else {
                        blockEntity.getInventory().m_6836_(0, ItemStack.f_41583_);
                    }
                    if (!recipe.getOutputFluid().isEmpty() && blockEntity.getTank().fill(recipe.getOutputFluid(), IFluidHandler.FluidAction.EXECUTE) == 0) {
                        IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, "Encountered an invalid recipe: " + String.valueOf(recipe.m_6423_()));
                    }
                    blockEntity.setProgress(0);
                } else {
                    blockEntity.setProgress(blockEntity.getProgress() + 1);
                    blockEntity.m_6596_();
                }
                blockEntity.setFire(0);
            } else if (blockEntity.getProgress() > 0 || blockEntity.getFire() > 0) {
                blockEntity.setProgress(0);
                blockEntity.setFire(0);
                blockEntity.m_6596_();
            }
        }
    }
}

