/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.gallery.core.data.client.GalleryAssetsRemolderProvider;
import com.teamabnormals.gallery.core.data.client.GalleryItemModelProvider;
import com.teamabnormals.neapolitan.client.model.BananaPeelModel;
import com.teamabnormals.neapolitan.client.model.ChimpanzeeHeadModel;
import com.teamabnormals.neapolitan.client.model.ChimpanzeeModel;
import com.teamabnormals.neapolitan.client.renderer.entity.BananaPeelRenderer;
import com.teamabnormals.neapolitan.client.renderer.entity.BananarrowRenderer;
import com.teamabnormals.neapolitan.client.renderer.entity.ChimpanzeeRenderer;
import com.teamabnormals.neapolitan.client.renderer.entity.PlantainSpiderRenderer;
import com.teamabnormals.neapolitan.core.NeapolitanConfig;
import com.teamabnormals.neapolitan.core.data.client.NeapolitanBlockStateProvider;
import com.teamabnormals.neapolitan.core.data.client.NeapolitanItemModelProvider;
import com.teamabnormals.neapolitan.core.data.client.NeapolitanSpriteSourceProvider;
import com.teamabnormals.neapolitan.core.data.server.NeapolitanDatapackBuiltinEntriesProvider;
import com.teamabnormals.neapolitan.core.data.server.NeapolitanLootTableProvider;
import com.teamabnormals.neapolitan.core.data.server.modifiers.NeapolitanAdvancementModifierProvider;
import com.teamabnormals.neapolitan.core.data.server.modifiers.NeapolitanLootModifierProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanBannerPatternTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanBiomeTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanBlockTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanEntityTypeTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanItemTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanMobEffectTagsProvider;
import com.teamabnormals.neapolitan.core.data.server.tags.NeapolitanPaintingVariantTagsProvider;
import com.teamabnormals.neapolitan.core.other.NeapolitanClientCompat;
import com.teamabnormals.neapolitan.core.other.NeapolitanCompat;
import com.teamabnormals.neapolitan.core.other.NeapolitanModelLayers;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBannerPatterns;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlockEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanDecoratedPotPatterns;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanFeatures;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanMobEffects;
import com.teamabnormals.neapolitan.core.registry.NeapolitanPaintingVariants;
import com.teamabnormals.neapolitan.core.registry.NeapolitanParticleTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanPoiTypes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="neapolitan")
@Mod.EventBusSubscriber(modid="neapolitan")
public class Neapolitan {
    public static final String MOD_ID = "neapolitan";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("neapolitan");

    public Neapolitan() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeMod.enableMilkFluid();
        REGISTRY_HELPER.register(bus);
        NeapolitanMobEffects.MOB_EFFECTS.register(bus);
        NeapolitanFeatures.FEATURES.register(bus);
        NeapolitanPoiTypes.POI_TYPES.register(bus);
        NeapolitanPaintingVariants.PAINTING_VARIANTS.register(bus);
        NeapolitanBannerPatterns.BANNER_PATTERNS.register(bus);
        NeapolitanParticleTypes.PARTICLE_TYPES.register(bus);
        NeapolitanDecoratedPotPatterns.DECORATED_POT_PATTERNS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            NeapolitanBlocks.setupTabEditors();
            NeapolitanItems.setupTabEditors();
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
            bus.addListener(this::createSkullModels);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeapolitanConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> NeapolitanCompat.registerCompat());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            SkullBlockRenderer.f_112519_.put(NeapolitanBlocks.NeapolitanSkullTypes.CHIMPANZEE, new ResourceLocation(MOD_ID, "textures/entity/chimpanzee/jungle_chimpanzee.png"));
            NeapolitanClientCompat.registerClientCompat();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        NeapolitanDatapackBuiltinEntriesProvider datapackEntries = new NeapolitanDatapackBuiltinEntriesProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        NeapolitanBlockTagsProvider blockTags = new NeapolitanBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new NeapolitanItemTagsProvider(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new NeapolitanEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new NeapolitanBannerPatternTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new NeapolitanBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new NeapolitanMobEffectTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new NeapolitanPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new NeapolitanLootTableProvider(output));
        generator.addProvider(server, (DataProvider)new NeapolitanLootModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new NeapolitanAdvancementModifierProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new NeapolitanBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new NeapolitanItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new NeapolitanSpriteSourceProvider(output, helper));
        generator.addProvider(client, (DataProvider)new GalleryItemModelProvider(MOD_ID, output, helper));
        generator.addProvider(client, (DataProvider)new GalleryAssetsRemolderProvider(MOD_ID, output, provider));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(NeapolitanModelLayers.BANANA_PEEL, BananaPeelModel::createBodyLayer);
        event.registerLayerDefinition(NeapolitanModelLayers.CHIMPANZEE, () -> ChimpanzeeModel.createBodyLayer(0.0f, false, false));
        event.registerLayerDefinition(NeapolitanModelLayers.CHIMPANZEE_INNER_ARMOR, () -> ChimpanzeeModel.createBodyLayer(0.5f, true, true));
        event.registerLayerDefinition(NeapolitanModelLayers.CHIMPANZEE_OUTER_ARMOR, () -> ChimpanzeeModel.createBodyLayer(1.0f, true, false));
        event.registerLayerDefinition(NeapolitanModelLayers.CHIMPANZEE_HEAD, ChimpanzeeHeadModel::createHeadLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.CHIMPANZEE.get(), ChimpanzeeRenderer::new);
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.PLANTAIN_SPIDER.get(), PlantainSpiderRenderer::new);
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.BANANA_PEEL.get(), BananaPeelRenderer::new);
        event.registerEntityRenderer((EntityType)NeapolitanEntityTypes.BANANARROW.get(), BananarrowRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)NeapolitanBlockEntityTypes.SKULL.get(), SkullBlockRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void createSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)NeapolitanBlocks.NeapolitanSkullTypes.CHIMPANZEE, (SkullModelBase)new ChimpanzeeHeadModel(event.getEntityModelSet().m_171103_(NeapolitanModelLayers.CHIMPANZEE_HEAD)));
    }
}

