/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.entity.goal;

import com.teamabnormals.blueprint.core.other.tags.BlueprintItemTags;
import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanItemTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class ChimpLookAtItemGoal
extends Goal {
    private final Chimpanzee chimpanzee;
    private ItemStack itemStack;
    private int lookTimer;
    private boolean wasHurt;

    public ChimpLookAtItemGoal(Chimpanzee chimpanzeeIn) {
        this.chimpanzee = chimpanzeeIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.chimpanzee.isDoingAction(ChimpanzeeAction.DEFAULT)) {
            return false;
        }
        if (!this.chimpanzee.m_21573_().m_26571_()) {
            return false;
        }
        if (this.chimpanzee.m_217043_().m_188503_(80) > 0) {
            return false;
        }
        ItemStack mainhanditem = this.chimpanzee.m_21205_();
        ItemStack offhanditem = this.chimpanzee.m_21206_();
        if (!mainhanditem.m_41619_()) {
            if (this.shouldLookAtItem(mainhanditem)) {
                this.itemStack = mainhanditem;
                return true;
            }
        } else if (!offhanditem.m_41619_() && this.shouldLookAtItem(offhanditem)) {
            this.chimpanzee.m_21008_(InteractionHand.MAIN_HAND, offhanditem);
            this.chimpanzee.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            this.itemStack = offhanditem;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.lookTimer = this.m_183277_(60 + this.chimpanzee.m_217043_().m_188503_(60));
        this.wasHurt = false;
        this.chimpanzee.setAction(ChimpanzeeAction.LOOKING_AT_ITEM);
        this.chimpanzee.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        if (this.chimpanzee.m_21205_() != this.itemStack) {
            return false;
        }
        return this.lookTimer > 0;
    }

    public void m_8041_() {
        this.chimpanzee.setDefaultAction();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.lookTimer;
        if (this.lookTimer == 0) {
            this.doItemInteraction();
        } else if (this.chimpanzee.isDoingAction(ChimpanzeeAction.PLAYING_WITH_ITEM)) {
            if (this.lookTimer == 20) {
                if (this.chimpanzee.m_217043_().m_188503_(10) == 0 && this.itemStack.m_204117_(BlueprintItemTags.BUCKETS_EMPTY)) {
                    this.chimpanzee.spawnItemFromBucket(new ItemStack((ItemLike)NeapolitanItems.BANANA.get()), this.chimpanzee.m_5737_());
                }
            } else if (this.lookTimer == 4) {
                if (this.itemStack.m_41720_() instanceof TieredItem) {
                    this.chimpanzee.m_6469_(this.chimpanzee.m_269291_().m_269264_(), 0.0f);
                    this.wasHurt = true;
                } else if (this.itemStack.m_41720_() instanceof FireworkRocketItem) {
                    this.chimpanzee.setOffFirework(this.itemStack, this.chimpanzee.m_5737_());
                    this.chimpanzee.m_21205_().m_41774_(1);
                    this.itemStack = this.chimpanzee.m_21205_();
                }
            }
        }
    }

    private void doItemInteraction() {
        Item item = this.itemStack.m_41720_();
        if (this.itemStack.m_204117_(NeapolitanItemTags.CHIMPANZEE_APE_MODE_ITEMS) && this.chimpanzee.getApeModeTime() <= 0) {
            this.lookTimer = 40;
            this.chimpanzee.setApeModeTime(1200 + this.chimpanzee.m_217043_().m_188503_(1200));
        } else if (this.shouldPlayWithItem(this.itemStack) && this.chimpanzee.isDoingAction(ChimpanzeeAction.LOOKING_AT_ITEM)) {
            this.lookTimer = 60 + this.chimpanzee.m_217043_().m_188503_(20);
            this.chimpanzee.setAction(ChimpanzeeAction.PLAYING_WITH_ITEM);
        } else {
            ArmorItem armorItem;
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD && this.chimpanzee.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                this.chimpanzee.m_8061_(EquipmentSlot.HEAD, this.itemStack);
                this.chimpanzee.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                this.chimpanzee.m_21409_(EquipmentSlot.HEAD, 2.0f);
                this.playEquipSound(item);
            } else if (this.chimpanzee.m_21205_() == this.itemStack) {
                this.chimpanzee.throwHeldItem(InteractionHand.MAIN_HAND);
            }
            if (this.wasHurt) {
                this.runAway();
            }
            this.chimpanzee.setDefaultAction();
        }
    }

    private void playEquipSound(Item item) {
        SoundEvent soundevent = ((ArmorItem)item).m_40401_().m_7344_();
        this.chimpanzee.m_5496_(soundevent, 1.0f, 1.0f);
    }

    private void runAway() {
        Vec3 vector3d = LandRandomPos.m_148488_((PathfinderMob)this.chimpanzee, (int)10, (int)5);
        if (vector3d != null) {
            this.chimpanzee.m_21573_().m_26519_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.25);
        }
        this.chimpanzee.m_21569_().m_24901_();
        this.chimpanzee.playScreamSound();
    }

    private boolean shouldLookAtItem(ItemStack stack) {
        return !this.chimpanzee.isSnack(stack) && !this.chimpanzee.isFavoriteItem(stack);
    }

    private boolean shouldPlayWithItem(ItemStack stack) {
        return stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof FireworkRocketItem || stack.m_204117_(BlueprintItemTags.BUCKETS_EMPTY);
    }
}

