/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.placementmodifier;

import com.mojang.serialization.Codec;
import gardensofthedead.registry.ModPlacementModifiers;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class CountOnEveryCeilingPlacement
extends PlacementModifier {
    public static final Codec<CountOnEveryCeilingPlacement> CODEC = IntProvider.m_146545_((int)0, (int)256).fieldOf("count").xmap(CountOnEveryCeilingPlacement::new, placementModifier -> placementModifier.count).codec();
    private final IntProvider count;

    private CountOnEveryCeilingPlacement(IntProvider count) {
        this.count = count;
    }

    public static CountOnEveryCeilingPlacement of(IntProvider count) {
        return new CountOnEveryCeilingPlacement(count);
    }

    public static CountOnEveryCeilingPlacement of(int count) {
        return CountOnEveryCeilingPlacement.of((IntProvider)ConstantInt.m_146483_((int)count));
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource randomSource, BlockPos pos) {
        boolean flag;
        Stream.Builder<BlockPos> builder = Stream.builder();
        int layer = 0;
        do {
            flag = false;
            for (int j = 0; j < this.count.m_214085_(randomSource); ++j) {
                int z;
                int y;
                int x = randomSource.m_188503_(16) + pos.m_123341_();
                int j1 = CountOnEveryCeilingPlacement.findOnGroundYPosition(context, x, y = context.m_191824_(Heightmap.Types.MOTION_BLOCKING, x, z = randomSource.m_188503_(16) + pos.m_123343_()), z, layer);
                if (j1 == Integer.MAX_VALUE) continue;
                builder.add(new BlockPos(x, j1, z));
                flag = true;
            }
            ++layer;
        } while (flag);
        return builder.build();
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)ModPlacementModifiers.COUNT_ON_EVERY_CEILING.get();
    }

    private static int findOnGroundYPosition(PlacementContext context, int xOrigin, int yOrigin, int zOrigin, int maxDepth) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(xOrigin, yOrigin, zOrigin);
        int layer = 0;
        BlockState previousState = context.m_191828_((BlockPos)pos);
        for (int y = yOrigin; y >= context.m_191830_() + 1; --y) {
            pos.m_142448_(y - 1);
            BlockState currentState = context.m_191828_((BlockPos)pos);
            if (!CountOnEveryCeilingPlacement.isEmpty(previousState) && CountOnEveryCeilingPlacement.isEmpty(currentState) && !previousState.m_60713_(Blocks.f_50752_)) {
                if (layer == maxDepth) {
                    return pos.m_123342_();
                }
                ++layer;
            }
            previousState = currentState;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isEmpty(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_);
    }
}

