/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.entity.brain.behaviors;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class AttackWithAnimation<E extends PathfinderMob>
extends Behavior<E> {
    protected boolean attack;
    protected final int leftActionPoint;
    protected final int attackLengh;
    private final int cooldownBetweenAttacks;
    private int cooldownTick;
    private final double speed;

    public AttackWithAnimation(int leftActionPoint, int attackLengh, int cooldownBetweenAttacks, double speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED));
        this.leftActionPoint = leftActionPoint;
        this.attackLengh = attackLengh;
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
        this.speed = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        LivingEntity livingentity = this.getAttackTarget(mob);
        return mob.m_142582_((Entity)livingentity);
    }

    protected void start(ServerLevel p_23524_, E p_23525_, long p_23526_) {
        LivingEntity livingentity = this.getAttackTarget(p_23525_);
        p_23525_.m_7618_(EntityAnchorArgument.Anchor.EYES, livingentity.m_20182_());
    }

    protected void tick(ServerLevel p_22551_, E p_22552_, long p_22553_) {
        super.m_6725_(p_22551_, p_22552_, p_22553_);
        LivingEntity livingentity = this.getAttackTarget(p_22552_);
        if (livingentity != null) {
            p_22552_.m_7618_(EntityAnchorArgument.Anchor.EYES, livingentity.m_20182_());
            p_22552_.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(livingentity.m_20182_(), 1.0f, 0));
            this.checkAndPerformAttack(p_22552_, livingentity, p_22551_);
            this.cooldownTick = Math.max(this.cooldownTick - 1, 0);
        }
    }

    protected boolean canStillUse(ServerLevel p_22545_, E p_22546_, long p_22547_) {
        return true;
    }

    protected void checkAndPerformAttack(E entity, LivingEntity p_29589_, ServerLevel serverLevel) {
        double d0 = entity.m_142593_(p_29589_);
        double d1 = entity.m_262793_(p_29589_);
        if (this.cooldownTick == this.leftActionPoint) {
            if (d1 <= d0) {
                entity.m_7327_((Entity)p_29589_);
            }
            if (this.cooldownTick == 0) {
                this.resetAttackCooldown();
            }
        } else if (d1 <= d0) {
            if (this.cooldownTick == this.attackLengh) {
                this.doTheAnimation(entity, serverLevel);
                this.attack = true;
            }
            if (this.cooldownTick == 0) {
                this.resetAttackCooldown();
            }
        } else if (this.cooldownTick == 0 || !this.attack) {
            this.resetAttackCooldown();
        }
    }

    public void doTheAnimation(E entity, ServerLevel serverLevel) {
        serverLevel.m_7605_(entity, (byte)4);
    }

    private void resetAttackCooldown() {
        this.cooldownTick = this.attackLengh + 1;
    }

    protected void stop(ServerLevel p_22548_, E p_22549_, long p_22550_) {
        super.m_6732_(p_22548_, p_22549_, p_22550_);
        p_22549_.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)this.cooldownBetweenAttacks);
    }

    private LivingEntity getAttackTarget(E p_23533_) {
        return p_23533_.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() ? (LivingEntity)p_23533_.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() : null;
    }
}

