/*
 * Decompiled with CFR 0.152.
 */
package com.lootintegrations.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lootintegrations.LootintegrationsMod;
import com.lootintegrations.config.CommonConfiguration;
import com.lootintegrations.loot.ILootTableID;
import com.lootintegrations.loot.INoMapContext;
import com.lootintegrations.loot.LootModifierManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class GlobalLootModifierIntegration {
    private final ResourceLocation location;
    public ResourceLocation lootTableId;
    public Map<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
    private int fillSize = 27;
    private static final String LOOT_TABLE_ID = "loot_table";
    private static final String INTEGRATED_LOOT_TABLES = "integrated_loot_tables";
    private static final String MAX_RESULT_ITEMCOUNT = "max_result_itemcount";

    private GlobalLootModifierIntegration(ResourceLocation location) {
        this.location = location;
    }

    public void doApply(List<ItemStack> generatedLoot, LootContext context, LootTable lootTable) {
        Object extraItems = new ArrayList();
        try {
            if (context instanceof INoMapContext) {
                INoMapContext noMapContext = (INoMapContext)context;
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipMapItems) {
                    noMapContext.disabledMaps();
                }
            }
            extraItems = context.m_78952_().m_7654_().m_278653_().m_278676_(this.lootTableId).m_230922_(context);
        }
        catch (Exception e) {
            LootintegrationsMod.LOGGER.debug("Loot generation of modifier:" + this.location + " for context failed for:" + this.lootTableId, (Throwable)e);
            return;
        }
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
            LootintegrationsMod.LOGGER.info("Adding loot to: " + ((ILootTableID)lootTable).getID() + " from: " + this.lootTableId + " caused by:" + this.location);
        }
        if (extraItems.isEmpty()) {
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.info("Zero items generated from " + this.lootTableId + ", recheck the lootable and its path");
            }
            return;
        }
        int itemCount = this.integratedTables.getOrDefault(((ILootTableID)lootTable).getID(), 1);
        if ((extraItems = this.aggregateStacks((List<ItemStack>)extraItems)).isEmpty()) {
            return;
        }
        if (!generatedLoot.isEmpty() && generatedLoot.size() + itemCount > this.fillSize) {
            List<ItemStack> newList = this.aggregateStacks(generatedLoot);
            generatedLoot.clear();
            generatedLoot.addAll(newList);
            if (generatedLoot.size() > this.fillSize) {
                int size = Math.min(generatedLoot.size(), generatedLoot.size() + itemCount - this.fillSize);
                for (int i = 0; i < size; ++i) {
                    generatedLoot.remove(LootintegrationsMod.rand.nextInt(generatedLoot.size()));
                }
            }
        }
        for (int i = 0; i < itemCount; ++i) {
            ItemStack stack = (ItemStack)extraItems.remove(LootintegrationsMod.rand.nextInt(extraItems.size()));
            generatedLoot.add(stack);
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.info("Adding loot to: " + ((ILootTableID)lootTable).getID() + " item:" + stack.toString());
            }
            if (extraItems.isEmpty()) break;
        }
    }

    private List<ItemStack> aggregateStacks(List<ItemStack> stacksIn) {
        HashMap<Item, ItemStack> aggregated = new HashMap<Item, ItemStack>();
        for (ItemStack stack : stacksIn) {
            ItemStack contained = (ItemStack)aggregated.get(stack.m_41720_());
            if (stack.m_41619_() || stack.m_204117_(LootModifierManager.IGNORED_FOR_LOOT)) continue;
            if (contained == null) {
                aggregated.put(stack.m_41720_(), stack);
                continue;
            }
            if (!GlobalLootModifierIntegration.compareItemStacksIgnoreStackSize(stack, contained, false, true)) continue;
            contained.m_41764_(Math.min(contained.m_41613_() + stack.m_41613_(), Math.max(1, contained.m_41741_() / 2)));
        }
        return new ArrayList<ItemStack>(aggregated.values());
    }

    public static GlobalLootModifierIntegration read(ResourceLocation location, JsonElement data) {
        GlobalLootModifierIntegration modifier = new GlobalLootModifierIntegration(location);
        JsonObject jsonData = (JsonObject)data;
        modifier.lootTableId = new ResourceLocation(jsonData.get(LOOT_TABLE_ID).getAsString());
        LootintegrationsMod.LOGGER.info("Parsing loot modifiers for:" + location + " with loottable: " + modifier.lootTableId);
        if (jsonData.has(MAX_RESULT_ITEMCOUNT)) {
            modifier.fillSize = jsonData.get(MAX_RESULT_ITEMCOUNT).getAsInt();
        }
        HashMap<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
        for (Map.Entry element : jsonData.get(INTEGRATED_LOOT_TABLES).getAsJsonObject().entrySet()) {
            ResourceLocation integratedTable = new ResourceLocation((String)element.getKey());
            integratedTables.put(integratedTable, ((JsonElement)element.getValue()).getAsInt());
        }
        modifier.integratedTables = integratedTables;
        return modifier;
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        if (itemStack1.m_41619_() && itemStack2.m_41619_()) {
            return true;
        }
        if (itemStack1.m_41619_() && !itemStack2.m_41619_() || !itemStack1.m_41619_() && itemStack2.m_41619_()) {
            return false;
        }
        if (itemStack1 == itemStack2) {
            return true;
        }
        if (!matchDamage || itemStack1.m_41773_() == itemStack2.m_41773_()) {
            if (!matchNBT) {
                return true;
            }
            if (itemStack1.m_41782_() && itemStack2.m_41782_()) {
                CompoundTag nbt1 = itemStack1.m_41783_();
                CompoundTag nbt2 = itemStack2.m_41783_();
                for (String key : nbt1.m_128431_()) {
                    if (!matchDamage && key.equals("Damage") || nbt2.m_128441_(key) && nbt1.m_128423_(key).equals(nbt2.m_128423_(key))) continue;
                    return false;
                }
                return nbt1.m_128431_().size() == nbt2.m_128431_().size();
            }
            return !(itemStack1.m_41782_() && !itemStack1.m_41783_().m_128456_() || itemStack2.m_41782_() && !itemStack2.m_41783_().m_128456_());
        }
        return false;
    }
}

