/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class VillageStructureModifier {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("empty"));
    private static final ResourceKey<StructureProcessorList> MOSSY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("mossify_10_percent"));

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, ResourceLocation poolRL, String nbtPieceRL, Holder<StructureProcessorList> processors, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, processors).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    public static void setup(RegistryAccess registryAccess) {
        SawmillMod.LOGGER.info("Injecting Carpenter Village Houses");
        Registry templatePoolRegistry = (Registry)registryAccess.m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)registryAccess.m_6632_(Registries.f_257011_).orElseThrow();
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "plains", "sawmill:plains_small", true, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "plains", "sawmill:plains_medium", true, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "snowy", "sawmill:snowy_small", false, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "snowy", "sawmill:snowy_medium", false, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "savanna", "sawmill:savanna_small", false, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "savanna", "sawmill:savanna_big", false, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "taiga", "sawmill:taiga_small", true, 1);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "taiga", "sawmill:taiga_big", true, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "taiga", "sawmill:taiga_medium", true, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "desert", "sawmill:desert_big", false, 2);
        VillageStructureModifier.addVillageHouse((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, "desert", "sawmill:desert_small", false, 2);
    }

    private static void addVillageHouse(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, String villageName, String pieceName, boolean mossy, int weight) {
        Holder.Reference normalProcessor = mossy ? processorListRegistry.m_246971_(MOSSY_PROCESSOR_LIST_KEY) : processorListRegistry.m_246971_(EMPTY_PROCESSOR_LIST_KEY);
        Holder.Reference zombieProcessor = processorListRegistry.m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("zombie_" + villageName)));
        VillageStructureModifier.addBuildingToPool(templatePoolRegistry, new ResourceLocation("village/" + villageName + "/houses"), pieceName, (Holder<StructureProcessorList>)normalProcessor, weight);
        VillageStructureModifier.addBuildingToPool(templatePoolRegistry, new ResourceLocation("village/" + villageName + "/zombie/houses"), pieceName, (Holder<StructureProcessorList>)zombieProcessor, weight);
    }
}

