/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;

public class VanillaUniversalBucketTemperature
implements ITemperature {
    private final ItemStack itemStack;

    public VanillaUniversalBucketTemperature(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    protected FluidStack getFluidStack() {
        return FluidUtil.getFluidContained((ItemStack)this.itemStack).orElse(FluidStack.EMPTY);
    }

    @Override
    public double getTemperature() {
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack == null) {
            return 273.15;
        }
        return fluidStack.getFluid().getFluidType().getTemperature(fluidStack);
    }

    @Override
    public double getMaximumTemperature() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getMinimumTemperature() {
        return 0.0;
    }

    @Override
    public double getDefaultTemperature() {
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack == null) {
            return 273.15;
        }
        return fluidStack.getFluid().getFluidType().getTemperature();
    }
}

