/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="snowundertrees")
public class LevelTickHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START && event.level.m_46471_() && ((Boolean)Configuration.CONFIG.enableWhenSnowing.get()).booleanValue()) {
                ServerLevel level = (ServerLevel)event.level;
                if (SnowUnderTrees.isSereneSeasonsLoaded() && !SereneSeasonsHandler.generateSnowAndIce()) {
                    return;
                }
                SnowUnderTrees.runForChunks(level, chunk -> {
                    int chunkZ;
                    ChunkPos chunkPos;
                    int chunkX;
                    BlockPos randomPos;
                    if (SnowUnderTrees.RANDOM.m_188503_(16) == 0 && level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, randomPos = level.m_46496_(chunkX = (chunkPos = chunk.m_7697_()).m_45604_(), 0, chunkZ = chunkPos.m_45605_(), 15)).m_7495_()).m_204336_(BlockTags.f_13035_)) {
                        BlockPos posBelow;
                        BlockState stateBelow;
                        BlockPos pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos);
                        if (SnowUnderTrees.isDynamicTreesLoaded()) {
                            pos = DynamicTreesHandler.findGround((WorldGenLevel)level, pos.m_122032_());
                        }
                        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome).toString());
                        if (!biomeDisabled && SnowUnderTrees.placeSnow((WorldGenLevel)level, pos) && (stateBelow = level.m_8055_(posBelow = pos.m_7495_())).m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                            level.m_7731_(posBelow, (BlockState)stateBelow.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                        }
                    }
                });
            } else if (event.phase == TickEvent.Phase.END && SnowUnderTrees.isSereneSeasonsLoaded()) {
                SereneSeasonsHandler.tryMeltSnowUnderTrees(event);
            }
        }
    }
}

