/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.data.server.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.uraneptus.sullysmod.core.registry.SMRecipeSerializer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GrindstonePolishingRecipeBuilder {
    private final RecipeCategory category;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Item result;
    private final int experience;
    private final int count;
    private final RecipeSerializer<?> serializer;
    private String recipeGroup;

    private GrindstonePolishingRecipeBuilder(RecipeCategory pCategory, ItemLike result, int count, int experience, RecipeSerializer<?> serializer) {
        this.category = pCategory;
        this.result = result.m_5456_();
        this.count = count;
        this.experience = experience;
        this.serializer = serializer;
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishing(RecipeCategory pCategory, ItemLike result) {
        return GrindstonePolishingRecipeBuilder.grindstonePolishing(pCategory, result, 1, 0);
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishingWithoutExperience(RecipeCategory pCategory, ItemLike result, int count) {
        return GrindstonePolishingRecipeBuilder.grindstonePolishing(pCategory, result, count, 0);
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishingWithoutCount(RecipeCategory pCategory, ItemLike result, int experience) {
        return GrindstonePolishingRecipeBuilder.grindstonePolishing(pCategory, result, 1, experience);
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishing(RecipeCategory pCategory, ItemLike result, int count, int experience) {
        return new GrindstonePolishingRecipeBuilder(pCategory, result, count, experience, (RecipeSerializer)SMRecipeSerializer.GRINDSTONE_POLISHING_SERIALIZER.get());
    }

    public GrindstonePolishingRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(Ingredient.m_204132_(pTag));
    }

    public GrindstonePolishingRecipeBuilder requires(ItemLike pItem) {
        return this.requires(pItem, 1);
    }

    public GrindstonePolishingRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}));
        }
        return this;
    }

    public GrindstonePolishingRecipeBuilder requires(Ingredient pIngredient) {
        return this.requires(pIngredient, 1);
    }

    public GrindstonePolishingRecipeBuilder requires(Ingredient pIngredient, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.ingredients.add(pIngredient);
        }
        return this;
    }

    public GrindstonePolishingRecipeBuilder group(String pGroupName) {
        this.recipeGroup = pGroupName;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, "");
    }

    public void save(Consumer<FinishedRecipe> consumer, String suffix) {
        ResourceLocation resultLocation = ForgeRegistries.ITEMS.getKey((Object)this.result);
        if (resultLocation != null) {
            consumer.accept(new Result(new ResourceLocation("sullysmod:grindstone_polishing/" + resultLocation.m_135815_() + suffix), this.serializer, this.recipeGroup == null ? "" : this.recipeGroup, this.ingredients, this.result, this.count, this.experience));
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final RecipeSerializer<?> serializer;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Item result;
        private final int count;
        private final int experience;

        public Result(ResourceLocation pId, RecipeSerializer<?> serializer, String pGroup, List<Ingredient> pIngredients, Item pResult, int count, int experience) {
            this.id = pId;
            this.serializer = serializer;
            this.group = pGroup;
            this.ingredients = pIngredients;
            this.result = pResult;
            this.count = count;
            this.experience = experience;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            pJson.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            pJson.add("result", (JsonElement)jsonobject);
            pJson.addProperty("experience", (Number)this.experience);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

