/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.data.server.advancements;

import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.core.other.SMTextDefinitions;
import com.uraneptus.sullysmod.core.other.tags.SMItemTags;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.data.SMDatagenUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class SMAdventureAdvancements
implements ForgeAdvancementProvider.AdvancementGenerator {
    ResourceLocation adventureParent = new ResourceLocation("adventure/root");
    public static List<Item> ARTIFACTS = SMItems.ARTIFACT_DESC_MAP.keySet().stream().map(RegistryObject::get).collect(Collectors.toList());
    public static List<Item> BIBLIOPHILE_ITEMS = List.of((Item)SMItems.TORN_MANUSCRIPT.get(), (Item)SMItems.LOST_JOURNAL.get(), (Item)SMItems.LOST_SKETCHBOOK.get(), (Item)SMItems.LOST_RECIPE_BOOK.get());
    public static List<Item> ALL_SKULL_ITEMS = SMBlocks.ANCIENT_SKULLS.stream().map(Supplier::get).map(Block::m_5456_).collect(Collectors.toList());
    public static List<Item> ALL_FOSSIL_ITEMS = List.of((Item)SMItems.FOSSILISED_BONE.get(), (Item)SMItems.FOSSILISED_FISH.get(), (Item)SMItems.FOSSILISED_FOOTSTEP.get(), (Item)SMItems.FOSSILISED_SHELLS.get());

    public void generate(HolderLookup.Provider registries, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement JADE_GRINDSET = this.createAdv("jade_grindset", null, FrameType.TASK, (ItemLike)SMItems.ROUGH_JADE.get(), SMTextDefinitions.JADE_GRINDSET_ADV, this.addCriterion("rough_jade", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)SMItems.ROUGH_JADE.get()})), null, saver, existingFileHelper);
        Advancement POLISH_JADE = this.createAdv("polish_jade", JADE_GRINDSET, FrameType.TASK, (ItemLike)SMItems.JADE.get(), SMTextDefinitions.POLISH_JADE_ADV, this.addCriterion("polished_jade", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)SMItems.JADE.get()})), null, saver, existingFileHelper);
        Advancement SHELL_HIT = this.createAdv("tortoise_shell_hit", null, FrameType.TASK, (ItemLike)SMItems.TORTOISE_SHELL.get(), SMTextDefinitions.SHELL_HIT_ADV, this.addCriterion("tortoise_shell", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_60149_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)SMEntityTypes.TORTOISE_SHELL.get()))))), null, saver, existingFileHelper);
        Advancement SHELL_HIT_RAVAGER = this.createAdv("tortoise_shell_hit_ravager", SHELL_HIT, FrameType.CHALLENGE, (ItemLike)SMItems.TORTOISE_SHELL.get(), SMTextDefinitions.SHELL_HIT_RAVAGER_ADV, this.addCriterion("tortoise_shell", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_156058_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)SMEntityTypes.TORTOISE_SHELL.get()))), (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20518_).m_36662_())), AdvancementRewards.Builder.m_10005_((int)50), saver, existingFileHelper);
        Advancement FILL_VIAL_JUNGLE_SPIDER = this.createAdv("glass_vial_filled_jungle_spider", null, FrameType.TASK, (ItemLike)SMItems.GLASS_VIAL.get(), SMTextDefinitions.FILL_VIAL_JUNGLE_SPIDER_ADV, this.addCriterion("harvest_venom", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)SMItems.VENOM_VIAL.get()})), null, saver, existingFileHelper);
        Advancement ITEM_STAND = this.createAdv("item_stand_crafted", null, FrameType.TASK, (ItemLike)SMBlocks.ITEM_STAND.get(), SMTextDefinitions.ITEM_STAND_ADV, this.addCriterion("craft_item_stand", (CriterionTriggerInstance)RecipeCraftedTrigger.TriggerInstance.m_280097_((ResourceLocation)SMDatagenUtil.craftingPath(SMDatagenUtil.name((Block)SMBlocks.ITEM_STAND.get())))), null, saver, existingFileHelper);
        Advancement FIRST_ARTIFACT = this.createAdv("first_artifact", null, FrameType.TASK, (ItemLike)SMItems.BROKEN_VASE.get(), SMTextDefinitions.FIRST_ARTIFACT_ADV, this.addCriterion("first_artifact", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(SMItemTags.ARTIFACTS).m_45077_()})), null, saver, existingFileHelper);
        Advancement LOST_CROWN = this.createAdv("find_lost_crown", FIRST_ARTIFACT, FrameType.TASK, (ItemLike)SMItems.LOST_CROWN.get(), SMTextDefinitions.LOST_CROWN_ADV, this.addCriterion("lost_crown", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)SMItems.LOST_CROWN.get()})), null, saver, existingFileHelper);
        Advancement BIBLIOPHILE = SMAdventureAdvancements.addCollectionAdv(BIBLIOPHILE_ITEMS, "bibliophile", this.createAdvBuilder(FIRST_ARTIFACT, FrameType.GOAL, (ItemLike)SMItems.TORN_MANUSCRIPT.get(), SMTextDefinitions.BIBLIOPHILE_ADV, null, null), saver, existingFileHelper);
        Advancement FIRST_SKULL = this.createAdv("first_skull", FIRST_ARTIFACT, FrameType.TASK, (ItemLike)((RegistryObject)SMBlocks.CRESTED_ANCIENT_SKULL.getFirst()).get(), SMTextDefinitions.FIRST_SKULL_ADV, this.addCriterion("first_skull", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(SMItemTags.ANCIENT_SKULLS).m_45077_()})), null, saver, existingFileHelper);
        Advancement ALL_SKULLS = SMAdventureAdvancements.addCollectionAdv(ALL_SKULL_ITEMS, "all_skulls", this.createAdvBuilder(FIRST_SKULL, FrameType.CHALLENGE, (ItemLike)((RegistryObject)SMBlocks.CRESTED_ANCIENT_SKULL.getFirst()).get(), SMTextDefinitions.ALL_SKULLS_ADV, null, AdvancementRewards.Builder.m_10005_((int)100)), saver, existingFileHelper);
        Advancement DRIED_FLOWERS = SMAdventureAdvancements.addCollectionAdv(List.of((Item)SMItems.DRIED_CYAN_FLOWER.get(), (Item)SMItems.DRIED_RED_FLOWER.get()), "dried_flowers", this.createAdvBuilder(FIRST_ARTIFACT, FrameType.GOAL, (ItemLike)SMItems.DRIED_CYAN_FLOWER.get(), SMTextDefinitions.DRIED_FLOWERS_ADV, null, null), saver, existingFileHelper);
        Advancement FIND_TABLETS = SMAdventureAdvancements.addCollectionAdv(List.of((Item)SMItems.MOON_TABLET.get(), (Item)SMItems.OMINOUS_TABLET.get()), "find_tablets", this.createAdvBuilder(FIRST_ARTIFACT, FrameType.GOAL, (ItemLike)SMItems.MOON_TABLET.get(), SMTextDefinitions.FIND_TABLETS_ADV, null, null), saver, existingFileHelper);
        Advancement ALL_FOSSILS = SMAdventureAdvancements.addCollectionAdv(ALL_FOSSIL_ITEMS, "all_fossils", this.createAdvBuilder(FIRST_ARTIFACT, FrameType.GOAL, (ItemLike)SMItems.FOSSILISED_BONE.get(), SMTextDefinitions.ALL_FOSSILS_ADV, null, null), saver, existingFileHelper);
        Advancement ALL_ARTIFACTS = SMAdventureAdvancements.addCollectionAdv(ARTIFACTS, "all_artifacts", this.createAdvBuilder(FIRST_ARTIFACT, FrameType.CHALLENGE, (ItemLike)SMItems.BROKEN_VASE.get(), SMTextDefinitions.ALL_ARTIFACTS_ADV, null, AdvancementRewards.Builder.m_10005_((int)700)), saver, existingFileHelper);
    }

    public Advancement createAdv(String advName, @Nullable Advancement parentAdvancement, FrameType type, ItemLike displayItem, Pair<Component, Component> titleDescPair, @Nullable Pair<String, CriterionTriggerInstance> criterionTriggerInstancePair, @Nullable AdvancementRewards.Builder reward, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        return this.createAdvBuilder(parentAdvancement, type, displayItem, titleDescPair, criterionTriggerInstancePair, reward).save(saver, SullysMod.modPrefix("adventure/" + advName), existingFileHelper);
    }

    public Advancement.Builder createAdvBuilder(@Nullable Advancement parentAdvancement, FrameType type, ItemLike displayItem, Pair<Component, Component> titleDescPair, @Nullable Pair<String, CriterionTriggerInstance> criterionTriggerInstancePair, @Nullable AdvancementRewards.Builder reward) {
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138371_(displayItem, (Component)titleDescPair.getLeft(), (Component)titleDescPair.getRight(), null, type, true, true, false).m_138360_(RequirementsStrategy.f_15979_);
        if (criterionTriggerInstancePair != null) {
            builder.m_138386_((String)criterionTriggerInstancePair.getLeft(), (CriterionTriggerInstance)criterionTriggerInstancePair.getRight());
        }
        if (reward != null) {
            builder.m_138356_(reward.m_10004_());
        }
        if (parentAdvancement == null) {
            builder.m_138396_(this.adventureParent);
        } else {
            builder.m_138398_(parentAdvancement);
        }
        return builder;
    }

    public Pair<String, CriterionTriggerInstance> addCriterion(String name, CriterionTriggerInstance triggerInstance) {
        return Pair.of((Object)name, (Object)triggerInstance);
    }

    private static Advancement addCollectionAdv(List<Item> itemsToCollect, String advName, Advancement.Builder pBuilder, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        for (Item item : itemsToCollect) {
            pBuilder.m_138386_(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item}));
        }
        pBuilder.m_138360_(RequirementsStrategy.f_15978_);
        return pBuilder.save(saver, SullysMod.modPrefix("adventure/" + advName), existingFileHelper);
    }
}

