/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.data.client;

import com.uraneptus.sullysmod.core.other.SMTextUtil;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMPaintingVariants;
import com.uraneptus.sullysmod.core.registry.SMPotions;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class SMLangProvider
extends LanguageProvider {
    public SMLangProvider(PackOutput packOutput, String modId) {
        super(packOutput, modId, "en_us");
    }

    protected void addTranslations() {
        SMBlocks.AUTO_TRANSLATE.forEach(this::forBlock);
        this.addBlock((Supplier)SMBlocks.JADE_BLOCK, "Block of Jade");
        this.addBlock((Supplier)SMBlocks.ROUGH_JADE_BLOCK, "Block of Rough Jade");
        SMItems.ARTIFACT_DESC_MAP.forEach((item, desc) -> this.forItem((Supplier<? extends Item>)item));
        SMItems.AUTO_TRANSLATE.forEach(this::forItem);
        this.add((Item)SMItems.VENOM_VIAL.get(), "Vial of Jungle Venom");
        this.add((Item)SMItems.LANTERNFISH_BUCKET.get(), "Bucket of Lanternfish");
        this.add((Item)SMItems.PIRANHA_BUCKET.get(), "Bucket of Piranha");
        this.add((Item)SMItems.LANTERNFISH.get(), "Raw Lanternfish");
        this.add((Item)SMItems.PIRANHA.get(), "Raw Piranha");
        this.addMusicDisc((Supplier<? extends Item>)SMItems.MUSIC_DISC_SCOUR, "LudoCrypt - scour");
        this.addMusicDisc((Supplier<? extends Item>)SMItems.MUSIC_DISC_SUNKEN_PAST, "_TurtleFood_ - Sunken Past");
        this.forEntity((Supplier<? extends EntityType<?>>)SMEntityTypes.LANTERNFISH);
        this.forEntity((Supplier<? extends EntityType<?>>)SMEntityTypes.TORTOISE);
        this.forEntity((Supplier<? extends EntityType<?>>)SMEntityTypes.TORTOISE_SHELL);
        this.forEntity((Supplier<? extends EntityType<?>>)SMEntityTypes.BOULDERING_ZOMBIE);
        this.forEntity((Supplier<? extends EntityType<?>>)SMEntityTypes.JUNGLE_SPIDER);
        this.forEntity((Supplier<? extends EntityType<?>>)SMEntityTypes.PIRANHA);
        SMPotions.POTION_TRANSLATIONS.forEach(this::addPotionsForEffect);
        this.add("subtitles.item.vial.shatter", "Vial shatters");
        this.add("subtitles.item.vial.fill", "Vial fills");
        this.add("subtitles.block.grindstone.polish_jade", "Grindstone polishes");
        this.add("subtitles.block.jade.ricochet", "Projectile ricochets");
        this.add("subtitles.block.flinger_totem.shoot", "Projectile flung");
        this.add("subtitles.block.flinger_totem.input_honey", "Projectile absorbed");
        this.add("subtitles.block.flinger_totem.add_honey", "Honey applied");
        this.add("subtitles.block.flinger_totem.reduce_honey", "Honey removed");
        this.add("subtitles.block.ancient_skull.crested", "Crested Skull echoes");
        this.add("subtitles.block.ancient_skull.cracked", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.flatbilled", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.gigantic", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.horned", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.long", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.tiny", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.wide", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.ribbed", "Proper Sound soon...");
        this.add("subtitles.block.ancient_skull.unicorn", "Proper Sound soon...");
        this.add("subtitles.block.amber.drip", "Amber drips");
        this.add("subtitles.entity.tortoise.ambient", "Tortoise chirps");
        this.add("subtitles.entity.tortoise.death", "Tortoise dies");
        this.add("subtitles.entity.tortoise.hurt", "Tortoise hurts");
        this.add("subtitles.entity.tortoise.hide", "Tortoise hides");
        this.add("subtitles.entity.tortoise.emerge", "Tortoise emerges");
        this.add("subtitles.entity.tortoise.hurt.hidden", "Tortoise hurts");
        this.add("subtitles.entity.tortoise.death_baby", "Tortoise baby dies");
        this.add("subtitles.entity.tortoise.hurt_baby", "Tortoise baby hurts");
        this.add("subtitles.entity.tortoise.egg_crack", "Tortoise Egg cracks");
        this.add("subtitles.entity.tortoise.egg_break", "Tortoise Egg breaks");
        this.add("subtitles.entity.tortoise.egg_hatch", "Tortoise Egg hatches");
        this.add("subtitles.entity.tortoise_shell.place", "Tortoise Shell placed");
        this.add("subtitles.entity.zombie.destroy_egg", "Egg stomped");
        this.add("subtitles.entity.lanternfish.flop", "Lanternfish flops");
        this.add("subtitles.entity.lanternfish.hurt", "Lanternfish hurts");
        this.add("subtitles.entity.lanternfish.death", "Lanternfish dies");
        this.add("subtitles.entity.piranha.flop", "Piranha flops");
        this.add("subtitles.entity.piranha.hurt", "Piranha hurts");
        this.add("subtitles.entity.piranha.death", "Piranha dies");
        this.add("subtitles.entity.bouldering_zombie.ambient", "Bouldering Zombie groans");
        this.add("subtitles.entity.bouldering_zombie.hurt", "Bouldering Zombie hurts");
        this.add("subtitles.entity.bouldering_zombie.death", "Bouldering Zombie dies");
        this.add("subtitles.item.throwing_knife.hit", "Knife hits entity");
        this.add("subtitles.item.throwing_knife.hit_ground", "Knife hits ground");
        this.add("subtitles.item.throwing_knife.throw", "Knife flies");
        this.add("subtitles.ambient.mountain.calls", "Echoes in the distance");
        this.add("subtitles.item.armor.equip_miners_helmet", "Miners Helmet clanks");
        this.add("subtitles.item.armor.equip_small_dented_helmet", "Small Dented Helmet clangs");
        this.add("subtitles.item.armor.equip_lost_crown", "Lost Crown clings");
        SMTextUtil.TRANSLATABLES.forEach((arg_0, arg_1) -> ((SMLangProvider)this).add(arg_0, arg_1));
        SMPaintingVariants.PAINTING_TRANSLATIONS.forEach(this::addPainting);
        this.add("death.attack.tortoise_shell", "%1$s took a Tortoise Shell to the knees");
        this.add("death.attack.tortoise_shell.player", "%1$s got bonked to death");
        this.add("death.attack.throwing_knife", "%1$s got sliced and diced");
        this.add("death.attack.throwing_knife.player", "%1$s was turned into a dart board by %2$s");
        this.add("fluid_type.sullysmod.molten_amber_fluid", "Molten Amber");
    }

    protected void addPainting(String name, String author) {
        this.add("painting.sullysmod." + name + ".title", SMTextUtil.createTranslation(name));
        this.add("painting.sullysmod." + name + ".author", author);
    }

    protected void addMusicDisc(Supplier<? extends Item> item, String description) {
        String disc = item.get().m_5524_();
        this.add(disc, "Music Disc");
        this.add(disc + ".desc", description);
    }

    protected void addPotionsForEffect(Supplier<? extends Potion> potionEffect, String name) {
        this.add(PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)potionEffect.get()), "Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)Items.f_42736_.m_7968_(), (Potion)potionEffect.get()), "Splash Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)Items.f_42739_.m_7968_(), (Potion)potionEffect.get()), "Lingering Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)Items.f_42738_.m_7968_(), (Potion)potionEffect.get()), "Arrow of " + name);
    }

    protected void forItem(Supplier<? extends Item> item) {
        this.addItem(item, SMTextUtil.createTranslation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.get())).m_135815_()));
    }

    protected void forBlock(Supplier<? extends Block> block) {
        this.addBlock(block, SMTextUtil.createTranslation(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block.get())).m_135815_()));
    }

    protected void forEntity(Supplier<? extends EntityType<?>> entity) {
        this.addEntityType(entity, SMTextUtil.createTranslation(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entity.get())).m_135815_()));
    }
}

