/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.integration.jei.category;

import com.google.common.collect.ImmutableList;
import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.common.recipes.GrindstonePolishingRecipe;
import com.uraneptus.sullysmod.core.integration.jei.JEIRecipeTypes;
import com.uraneptus.sullysmod.core.other.SMTextDefinitions;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SMPolishingCategory
implements IRecipeCategory<GrindstonePolishingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public SMPolishingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(SullysMod.modPrefix("textures/gui/jei/grindstone_polishing.png"), 0, 0, 96, 31);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42773_));
    }

    public Component getTitle() {
        return SMTextDefinitions.JEI_POLISHING_TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public RecipeType<GrindstonePolishingRecipe> getRecipeType() {
        return JEIRecipeTypes.GRINDSTONE_POLISHING;
    }

    public void setRecipe(IRecipeLayoutBuilder layout, GrindstonePolishingRecipe polishingRecipes, IFocusGroup ingredients) {
        layout.addSlot(RecipeIngredientRole.INPUT, 4, 9).addIngredients((Ingredient)polishingRecipes.m_7527_().iterator().next());
        layout.addSlot(RecipeIngredientRole.OUTPUT, 76, 9).addItemStack(new ItemStack((ItemLike)polishingRecipes.result.m_41720_(), polishingRecipes.getResultCount()));
    }

    public List<Component> getTooltipStrings(GrindstonePolishingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (SMPolishingCategory.iconPosition(31, 3, mouseX, mouseY)) {
            return ImmutableList.of((Object)SMTextDefinitions.JEI_POLISHING_INFO);
        }
        return Collections.emptyList();
    }

    private static boolean iconPosition(int x, int y, double mouseX, double mouseY) {
        int iconHeight = 25;
        int iconWidth = 26;
        return (double)x <= mouseX && mouseX < (double)(x + 26) && (double)y <= mouseY && mouseY < (double)(y + 25);
    }
}

