/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.events;

import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.common.entities.BoulderingZombie;
import com.uraneptus.sullysmod.common.entities.JungleSpider;
import com.uraneptus.sullysmod.common.entities.Lanternfish;
import com.uraneptus.sullysmod.common.entities.Piranha;
import com.uraneptus.sullysmod.common.entities.Tortoise;
import com.uraneptus.sullysmod.core.SMConfig;
import com.uraneptus.sullysmod.core.SMFeatures;
import com.uraneptus.sullysmod.core.other.SMTextDefinitions;
import com.uraneptus.sullysmod.core.other.tags.SMBiomeTags;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;

@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SMCommonModEvents {
    @SubscribeEvent
    public static void registerSpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)SMEntityTypes.LANTERNFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Lanternfish::checkLanternfishSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SMEntityTypes.PIRANHA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Piranha::checkPiranhaSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SMEntityTypes.TORTOISE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Tortoise::checkTortoiseSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SMEntityTypes.BOULDERING_ZOMBIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BoulderingZombie::checkBoulderingZombieSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SMEntityTypes.JUNGLE_SPIDER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, JungleSpider::checkJungleSpiderSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register(EntityType.f_20501_, SMCommonModEvents::zombieExtraRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register(EntityType.f_20479_, SMCommonModEvents::spiderExtraRules, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public static boolean zombieExtraRules(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return (Boolean)SMConfig.DISABLE_DEEPSLATE_ZOMBIE_SPAWNS.get() == false || !SMFeatures.isEnabled(SMFeatures.BOULDERING_ZOMBIE) || pSpawnType.equals((Object)MobSpawnType.SPAWNER) || pPos.m_123342_() > 0;
    }

    public static boolean spiderExtraRules(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return (Boolean)SMConfig.DISABLE_SPIDER_IN_JUNGLE_SPAWNS.get() == false || !SMFeatures.isEnabled(SMFeatures.JUNGLE_SPIDER) || pSpawnType.equals((Object)MobSpawnType.SPAWNER) || !pLevel.m_204166_(pPos).m_203656_(SMBiomeTags.JUNGLE_SPIDER_SPAWN_IN);
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        event.addRepositorySource(consumer -> {
            String path = SullysMod.modPrefix("mob_retextures").toString();
            IModFile file = ModList.get().getModFileById("sullysmod").getFile();
            try (PathPackResources packResources = new PathPackResources(path, true, file.findResource(new String[]{"builtin/mob_retextures"}));){
                consumer.accept(Pack.m_245429_((String)path, (Component)SMTextDefinitions.RETEXTURES_PACK_DISPLAY_NAME, (boolean)false, id -> packResources, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
            }
        });
    }
}

