/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.client.model.BoulderingZombieModel;
import com.uraneptus.sullysmod.client.model.JadeShieldModel;
import com.uraneptus.sullysmod.client.model.JungleSpiderModel;
import com.uraneptus.sullysmod.client.model.LanternfishModel;
import com.uraneptus.sullysmod.client.model.MinersHelmetModel;
import com.uraneptus.sullysmod.client.model.PiranhaModel;
import com.uraneptus.sullysmod.client.model.TortoiseModel;
import com.uraneptus.sullysmod.client.model.TortoiseShellModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.CrackedAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.CrestedAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.FlatbilledAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.GiganticAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.HornedAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.LongAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.RibbedAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.TinyAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.UnicornAncientSkullModel;
import com.uraneptus.sullysmod.client.model.ancient_skulls.WideAncientSkullModel;
import com.uraneptus.sullysmod.client.particles.AmberParticle;
import com.uraneptus.sullysmod.client.particles.BlotEyesParticle;
import com.uraneptus.sullysmod.client.particles.RicochetParticle;
import com.uraneptus.sullysmod.client.renderer.be.AmberBER;
import com.uraneptus.sullysmod.client.renderer.be.ItemStandBER;
import com.uraneptus.sullysmod.client.renderer.entities.BoulderingZombieRenderer;
import com.uraneptus.sullysmod.client.renderer.entities.JungleSpiderRenderer;
import com.uraneptus.sullysmod.client.renderer.entities.LanternfishRenderer;
import com.uraneptus.sullysmod.client.renderer.entities.PiranhaRenderer;
import com.uraneptus.sullysmod.client.renderer.entities.ThrownThrowingKnifeRenderer;
import com.uraneptus.sullysmod.client.renderer.entities.TortoiseRenderer;
import com.uraneptus.sullysmod.client.renderer.entities.TortoiseShellRenderer;
import com.uraneptus.sullysmod.client.renderer.entities.layer.StuckInAmberLayer;
import com.uraneptus.sullysmod.common.blocks.AncientSkullBlock;
import com.uraneptus.sullysmod.common.items.VenomVialItem;
import com.uraneptus.sullysmod.core.registry.SMBlockEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SMClientModEvents {
    @SubscribeEvent
    public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SMEntityTypes.LANTERNFISH.get(), LanternfishRenderer::new);
        event.registerEntityRenderer((EntityType)SMEntityTypes.TORTOISE.get(), TortoiseRenderer::new);
        event.registerEntityRenderer((EntityType)SMEntityTypes.TORTOISE_SHELL.get(), TortoiseShellRenderer::new);
        event.registerEntityRenderer((EntityType)SMEntityTypes.BOULDERING_ZOMBIE.get(), BoulderingZombieRenderer::new);
        event.registerEntityRenderer((EntityType)SMEntityTypes.JUNGLE_SPIDER.get(), JungleSpiderRenderer::new);
        event.registerEntityRenderer((EntityType)SMEntityTypes.PIRANHA.get(), PiranhaRenderer::new);
        event.registerEntityRenderer((EntityType)SMEntityTypes.THROWN_THROWING_KNIFE.get(), ThrownThrowingKnifeRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SMBlockEntityTypes.AMBER.get(), AmberBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)SMBlockEntityTypes.ITEM_STAND.get(), ItemStandBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)SMBlockEntityTypes.ANCIENT_SKULL.get(), SkullBlockRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerLocation(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition INNER_ARMOR_DEF = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(0.5f)), (int)64, (int)32);
        LayerDefinition OUTER_ARMOR_DEF = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(1.0f)), (int)64, (int)32);
        event.registerLayerDefinition(LanternfishModel.LAYER_LOCATION, LanternfishModel::createBodyLayer);
        event.registerLayerDefinition(JadeShieldModel.LAYER_LOCATION, JadeShieldModel::createLayer);
        event.registerLayerDefinition(TortoiseShellModel.LAYER_LOCATION, TortoiseShellModel::createBodyLayer);
        event.registerLayerDefinition(TortoiseModel.LAYER_LOCATION, TortoiseModel::createBodyLayer);
        event.registerLayerDefinition(JungleSpiderModel.LAYER_LOCATION, JungleSpiderModel::createBodyLayer);
        event.registerLayerDefinition(BoulderingZombieModel.LAYER_LOCATION, BoulderingZombieModel::createBodyLayer);
        event.registerLayerDefinition(BoulderingZombieModel.INNER_ARMOR, () -> INNER_ARMOR_DEF);
        event.registerLayerDefinition(BoulderingZombieModel.OUTER_ARMOR, () -> OUTER_ARMOR_DEF);
        event.registerLayerDefinition(PiranhaModel.LAYER_LOCATION, PiranhaModel::createBodyLayer);
        event.registerLayerDefinition(MinersHelmetModel.LAYER_LOCATION, MinersHelmetModel::createBodyLayer);
        event.registerLayerDefinition(CrackedAncientSkullModel.LAYER_LOCATION, CrackedAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(CrestedAncientSkullModel.LAYER_LOCATION, CrestedAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(FlatbilledAncientSkullModel.LAYER_LOCATION, FlatbilledAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(GiganticAncientSkullModel.LAYER_LOCATION, GiganticAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(HornedAncientSkullModel.LAYER_LOCATION, HornedAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(LongAncientSkullModel.LAYER_LOCATION, LongAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(TinyAncientSkullModel.LAYER_LOCATION, TinyAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(WideAncientSkullModel.LAYER_LOCATION, WideAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(RibbedAncientSkullModel.LAYER_LOCATION, RibbedAncientSkullModel::createBodyLayer);
        event.registerLayerDefinition(UnicornAncientSkullModel.LAYER_LOCATION, UnicornAncientSkullModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerParticleProvider(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SMParticleTypes.RICOCHET.get(), RicochetParticle.RicochetParticleProvider::new);
        event.registerSpriteSet((ParticleType)SMParticleTypes.BLOT_EYES.get(), BlotEyesParticle.Factory::new);
        event.registerSprite((ParticleType)SMParticleTypes.AMBER_DRIPPING.get(), AmberParticle::createAmberHangParticle);
        event.registerSprite((ParticleType)SMParticleTypes.AMBER_FALL.get(), AmberParticle::createAmberFallParticle);
        event.registerSprite((ParticleType)SMParticleTypes.AMBER_LAND.get(), AmberParticle::createAmberLandParticle);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)SMItems.JADE_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (itemStack, clientWorld, livingEntity, useTime) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        SkullBlockRenderer.f_112519_.putAll((Map)Util.m_137469_((Object)Maps.newHashMap(), SMClientModEvents::addSkull));
    }

    public static void addSkull(Map<SkullBlock.Type, ResourceLocation> map) {
        for (AncientSkullBlock.Types type : AncientSkullBlock.Types.values()) {
            map.put(type, SullysMod.modPrefix("textures/entity/ancient_skulls/" + ((Object)((Object)type)).toString().toLowerCase() + ".png"));
        }
    }

    @SubscribeEvent
    public static void onItemColouring(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tint) -> tint == 0 ? -1 : VenomVialItem.getEffectColours(stack, tint), new ItemLike[]{(ItemLike)SMItems.VENOM_VIAL.get()});
    }

    @SubscribeEvent
    public static void onCreateSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.CRACKED, (SkullModelBase)new CrackedAncientSkullModel(event.getEntityModelSet().m_171103_(CrackedAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.CRESTED, (SkullModelBase)new CrestedAncientSkullModel(event.getEntityModelSet().m_171103_(CrestedAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.FLATBILLED, (SkullModelBase)new FlatbilledAncientSkullModel(event.getEntityModelSet().m_171103_(FlatbilledAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.GIGANTIC, (SkullModelBase)new GiganticAncientSkullModel(event.getEntityModelSet().m_171103_(GiganticAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.HORNED, (SkullModelBase)new HornedAncientSkullModel(event.getEntityModelSet().m_171103_(HornedAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.LONG, (SkullModelBase)new LongAncientSkullModel(event.getEntityModelSet().m_171103_(LongAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.TINY, (SkullModelBase)new TinyAncientSkullModel(event.getEntityModelSet().m_171103_(TinyAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.WIDE, (SkullModelBase)new WideAncientSkullModel(event.getEntityModelSet().m_171103_(WideAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.RIBBED, (SkullModelBase)new RibbedAncientSkullModel(event.getEntityModelSet().m_171103_(RibbedAncientSkullModel.LAYER_LOCATION)));
        event.registerSkullModel((SkullBlock.Type)AncientSkullBlock.Types.UNICORN, (SkullModelBase)new UnicornAncientSkullModel(event.getEntityModelSet().m_171103_(UnicornAncientSkullModel.LAYER_LOCATION)));
    }

    @SubscribeEvent
    public static void addRenderLayers(EntityRenderersEvent.AddLayers event) {
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(DefaultAttributes::m_22301_).map(entityType -> entityType).collect(Collectors.toList()));
        entityTypes.forEach(entityType -> {
            LivingEntityRenderer renderer = null;
            if (entityType != EntityType.f_20565_) {
                try {
                    renderer = event.getRenderer(entityType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (renderer != null) {
                    renderer.m_115326_(new StuckInAmberLayer(renderer));
                }
            }
        });
    }
}

