/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.core.SMFeatures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class SMFeatureRecipeCondition
implements ICondition {
    private static final ResourceLocation ID = SullysMod.modPrefix("mod_features");
    private final List<SMFeatures> condition;

    public SMFeatureRecipeCondition(List<SMFeatures> condition) {
        this.condition = condition;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return this.condition.stream().allMatch(SMFeatures::isEnabled);
    }

    public static class Serializer
    implements IConditionSerializer<SMFeatureRecipeCondition> {
        private final ResourceLocation location = SullysMod.modPrefix("mod_features");

        public void write(JsonObject json, SMFeatureRecipeCondition value) {
            JsonArray values = new JsonArray();
            for (SMFeatures feature : value.condition) {
                values.add(feature.m_7912_());
            }
            json.add("values", (JsonElement)values);
        }

        public SMFeatureRecipeCondition read(JsonObject json) {
            ArrayList<SMFeatures> features = new ArrayList<SMFeatures>();
            for (JsonElement element : json.getAsJsonArray("values")) {
                SMFeatures feature = SMFeatures.byName(element.getAsString());
                features.add(feature);
            }
            return new SMFeatureRecipeCondition(features);
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

