/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactWeaponItem
extends Item {
    @Nullable
    private final Supplier<SoundEvent> customBreakSound;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ArtifactWeaponItem(int damage, float speed, @Nullable Supplier<SoundEvent> customBreakSound, Item.Properties pProperties) {
        super(pProperties);
        this.customBreakSound = customBreakSound;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, entity -> {
            if (this.customBreakSound == null) {
                entity.m_21166_(EquipmentSlot.MAINHAND);
            } else {
                pAttacker.m_9236_().m_5594_(null, pAttacker.m_20097_(), this.customBreakSound.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        });
        return true;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }
}

