/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.fluids;

import com.uraneptus.sullysmod.core.other.tags.SMBlockTags;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMFluidTypes;
import com.uraneptus.sullysmod.core.registry.SMFluids;
import com.uraneptus.sullysmod.core.registry.SMItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.NotNull;

public class MoltenAmberFluid
extends ForgeFlowingFluid {
    public static final float MIN_LEVEL_CUTOFF = 0.44444445f;

    protected MoltenAmberFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public FluidType getFluidType() {
        return (FluidType)SMFluidTypes.MOLTEN_AMBER_FLUID_TYPE.get();
    }

    public Fluid m_5615_() {
        return (Fluid)SMFluids.FLOWING_MOLTEN_AMBER.get();
    }

    public Fluid m_5613_() {
        return (Fluid)SMFluids.SOURCE_MOLTEN_AMBER.get();
    }

    public Item m_6859_() {
        return (Item)SMItems.MOLTEN_AMBER_BUCKET.get();
    }

    public void m_213812_(Level pLevel, BlockPos pPos, FluidState pState, RandomSource pRandom) {
        int k = 2;
        if (pState.m_76170_()) {
            k = 15;
        }
        if (pRandom.m_188503_(k) == 0) {
            boolean cooldown = true;
            if (pLevel.m_46472_() == Level.f_46429_) {
                cooldown = false;
            } else {
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-1, -1, -1), (BlockPos)pPos.m_7918_(1, 1, 1))) {
                    if (!pLevel.m_8055_(pos).m_204336_(SMBlockTags.MELTS_AMBER) || pLevel.m_8055_(pos).m_60713_((Block)SMBlocks.MOLTEN_AMBER_BLOCK.get())) continue;
                    cooldown = false;
                    break;
                }
            }
            if (cooldown && pLevel.m_8055_(pPos).m_60734_() instanceof LiquidBlock) {
                pLevel.m_7731_(pPos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)pLevel, (BlockPos)pPos, (BlockPos)pPos, (BlockState)((Block)SMBlocks.AMBER.get()).m_49966_()), 3);
            }
        }
    }

    public int m_6719_(LevelReader pLevel) {
        return pLevel.m_6042_().f_63857_() ? 4 : 2;
    }

    @NotNull
    public BlockState m_5804_(FluidState pState) {
        return (BlockState)((LiquidBlock)SMBlocks.MOLTEN_AMBER_BLOCK.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(MoltenAmberFluid.m_76092_((FluidState)pState)));
    }

    public boolean m_7444_(FluidState fluidState) {
        return false;
    }

    public boolean m_6212_(Fluid pFluid) {
        return pFluid == SMFluids.SOURCE_MOLTEN_AMBER.get() || pFluid == SMFluids.FLOWING_MOLTEN_AMBER.get();
    }

    public int m_6713_(LevelReader pLevel) {
        return pLevel.m_6042_().f_63857_() ? 1 : 2;
    }

    public boolean m_5486_(FluidState pFluidState, BlockGetter pBlockReader, BlockPos pPos, Fluid pFluid, Direction pDirection) {
        return pFluidState.m_76155_(pBlockReader, pPos) >= 0.44444445f && pFluid.m_205067_(FluidTags.f_13131_);
    }

    public int m_6718_(LevelReader pLevel) {
        return pLevel.m_6042_().f_63857_() ? 10 : 30;
    }

    public int m_6886_(Level pLevel, BlockPos pPos, FluidState pCurrentState, FluidState pNewState) {
        int i = this.m_6718_((LevelReader)pLevel);
        if (!(pCurrentState.m_76178_() || pNewState.m_76178_() || ((Boolean)pCurrentState.m_61143_((Property)f_75947_)).booleanValue() || ((Boolean)pNewState.m_61143_((Property)f_75947_)).booleanValue() || !(pNewState.m_76155_((BlockGetter)pLevel, pPos) > pCurrentState.m_76155_((BlockGetter)pLevel, pPos)) || pLevel.m_213780_().m_188503_(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    public int m_7430_(FluidState fluidState) {
        return (Integer)fluidState.m_61143_((Property)f_75948_);
    }

    protected boolean m_6760_(Level pLevel) {
        return pLevel.m_46469_().m_46207_(GameRules.f_254672_);
    }

    protected void m_6364_(LevelAccessor pLevel, BlockPos pPos, BlockState pBlockState, Direction pDirection, FluidState pFluidState) {
        FluidState fluidstate;
        if (pDirection == Direction.DOWN && (fluidstate = pLevel.m_6425_(pPos)).m_205070_(FluidTags.f_13131_)) {
            if (pBlockState.m_60734_() instanceof LiquidBlock) {
                pLevel.m_7731_(pPos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)pLevel, (BlockPos)pPos, (BlockPos)pPos, (BlockState)((Block)SMBlocks.AMBER.get()).m_49966_()), 3);
            }
            return;
        }
        super.m_6364_(pLevel, pPos, pBlockState, pDirection, pFluidState);
    }

    protected boolean m_6685_() {
        return true;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public Optional<SoundEvent> m_142520_() {
        return Optional.of(SoundEvents.f_11783_);
    }

    public static class Flowing
    extends MoltenAmberFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> pBuilder) {
            super.m_7180_(pBuilder);
            pBuilder.m_61104_(new Property[]{f_75948_});
        }

        @Override
        public int m_7430_(FluidState pState) {
            return (Integer)pState.m_61143_((Property)f_75948_);
        }
    }

    public static class Source
    extends MoltenAmberFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        @Override
        public int m_7430_(FluidState pState) {
            return 8;
        }

        @Override
        public boolean m_7444_(FluidState pState) {
            return true;
        }
    }
}

