/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.common.entities.WorkstationAttachable;
import com.uraneptus.sullysmod.core.other.tags.SMBlockTags;
import com.uraneptus.sullysmod.core.registry.SMDamageTypes;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PlayMessages;

public class TortoiseShell
extends Entity
implements OwnableEntity,
WorkstationAttachable {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Integer> SPIN_TICKS = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> WORKSTATION = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> RECORD_ITEM = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> IS_RECORD_PLAYING = SynchedEntityData.m_135353_(TortoiseShell.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    long recordTickCount;
    long recordStartedTick;
    int ticksSinceLastEvent;

    public TortoiseShell(EntityType<? extends TortoiseShell> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
    }

    public TortoiseShell(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends TortoiseShell>)((EntityType)SMEntityTypes.TORTOISE_SHELL.get()), level);
    }

    public void setOwner(LivingEntity pOwner) {
        this.setOwnerUUID(pOwner.m_20148_());
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(pUuid));
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        float additionalHeight = this.hasAppliedWorkstation() ? 0.25f : 0.0f;
        return super.m_6972_(pPose).m_20390_(1.0f, 1.0f + additionalHeight);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPIN_TICKS, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(WORKSTATION, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(RECORD_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(IS_RECORD_PLAYING, (Object)false);
    }

    public Integer getSpinTicksEntityData() {
        return (Integer)this.f_19804_.m_135370_(SPIN_TICKS);
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    protected Vec3 m_7643_(Direction.Axis pAxis, BlockUtil.FoundRectangle pPortal) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(pAxis, pPortal));
    }

    public void setSpinTimer() {
        this.f_19804_.m_135381_(SPIN_TICKS, (Object)22);
    }

    @Override
    public InteractionResult customInteraction(Player player, InteractionHand hand) {
        double yLookAnglePlayer = player.m_20154_().m_82507_(Direction.Axis.Y);
        double y = this.m_20184_().m_82507_(Direction.Axis.Y);
        double x = this.m_20185_() - player.m_20185_();
        double z = this.m_20189_() - player.m_20189_();
        if (y == -0.0 && !this.isInFluidType() && yLookAnglePlayer > -0.6 && yLookAnglePlayer < 0.1 && this.getSpinTicksEntityData() == 0) {
            double d2 = Math.max(x * x + z * z, 0.001);
            this.m_20334_(x / d2 * 2.1, 0.05, z / d2 * 2.1);
            this.setSpinTimer();
            this.setOwner((LivingEntity)player);
            this.m_146922_(player.m_146908_());
            this.f_19859_ = this.m_146908_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        return this.workstationInteraction(pPlayer, pHand, this);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource == this.m_269291_().m_269325_() || pSource == this.m_269291_().m_269549_() || pSource == this.m_269291_().m_269387_()) {
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)this.getDropItem());
            }
            this.m_146870_();
        }
        if (pSource == this.m_269291_().m_269233_()) {
            this.m_146870_();
        }
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            Entity entity = pSource.m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                boolean flag = player.m_150110_().f_35937_;
                if (flag || this.getDamage() > 40.0f) {
                    if (!flag && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_) && pSource != this.m_269291_().m_269233_() && pSource != this.m_269291_().m_269325_() && pSource != this.m_269291_().m_269387_() && pSource != this.m_269291_().m_269549_()) {
                        this.m_19998_((ItemLike)this.getDropItem());
                    }
                    this.m_146870_();
                }
            }
            return true;
        }
        return true;
    }

    public Item getDropItem() {
        return (Item)SMItems.TORTOISE_SHELL.get();
    }

    public void m_6053_(float pYaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    private void hurtEntity(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            Ravager ravagerEntity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                LivingEntity owner = this.m_269323_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (player.m_21254_()) {
                        player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 100);
                        player.m_5810_();
                        player.m_9236_().m_7605_((Entity)player, (byte)30);
                    }
                    if (!player.m_21254_()) {
                        this.handleDamage(owner, entity);
                    }
                } else {
                    this.handleDamage(owner, entity);
                }
            }
            if (!(entity instanceof Ravager) || (ravagerEntity = (Ravager)entity).m_33364_() != 0 || ravagerEntity.m_33366_() != 0) continue;
            ravagerEntity.m_7822_((byte)39);
            ravagerEntity.m_5496_(SoundEvents.f_12362_, 1.0f, 1.0f);
            ravagerEntity.m_9236_().m_7605_((Entity)ravagerEntity, (byte)39);
        }
    }

    public void handleDamage(@Nullable LivingEntity owner, Entity entity) {
        if (owner == null) {
            entity.m_6469_(this.m_269291_().m_268998_(SMDamageTypes.TORTOISE_SHELL, (Entity)this, (Entity)this), 4.0f);
        } else {
            entity.m_6469_(this.m_269291_().m_268998_(SMDamageTypes.TORTOISE_SHELL, (Entity)this, (Entity)owner), 4.0f);
            owner.m_21335_(entity);
        }
    }

    private void hitShield(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            Player player;
            if (!(entity instanceof Player) || !(player = (Player)entity).m_21254_()) continue;
            double x = player.m_20185_() - this.m_20185_();
            double z = player.m_20189_() - this.m_20189_();
            double shellX = this.m_20185_() - player.m_20185_();
            double shellZ = this.m_20189_() - player.m_20189_();
            double d2 = Math.max(x * x + z * z, 0.001);
            this.m_20334_(shellX / d2 * 0.4, 0.005, shellZ / d2 * 0.4);
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 100);
            player.m_5810_();
            player.m_9236_().m_7605_((Entity)player, (byte)30);
        }
    }

    private void knockBack(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            double x = entity.m_20185_() - this.m_20185_();
            double z = entity.m_20189_() - this.m_20189_();
            double shellX = this.m_20185_() - entity.m_20185_();
            double shellZ = this.m_20189_() - entity.m_20189_();
            double d2 = Math.max(x * x + z * z, 0.001);
            this.m_20334_(shellX / d2 * 0.4, 0.005, shellZ / d2 * 0.4);
            entity.m_5997_(x / d2 * 0.05, 0.005, z / d2 * 0.05);
        }
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected static BlockHitResult getTortoiseShellPOVHitResult(Level pLevel, Entity entity, ClipContext.Fluid pFluidMode) {
        float xRot = entity.m_146909_();
        float yRot = entity.m_146908_();
        Vec3 vec3 = entity.m_146892_();
        float f2 = Mth.m_14089_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-xRot * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-xRot * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double range = 1.15;
        Vec3 vec31 = vec3.m_82520_((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return pLevel.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, pFluidMode, entity));
    }

    private void blockKnockBack() {
        Vec3 vec3 = this.m_20184_();
        BlockHitResult hitResult = TortoiseShell.getTortoiseShellPOVHitResult(this.m_9236_(), this, ClipContext.Fluid.NONE);
        BlockPos blockPos = hitResult.m_82425_();
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            if (hitResult.m_82434_().m_122434_() == Direction.Axis.X) {
                this.shoot(this.m_20184_().m_82548_().f_82479_, vec3.f_82480_, vec3.f_82481_, 0.8f, 0.0f);
                this.m_146922_(this.m_146908_() + 180.0f);
                this.f_19859_ = this.m_146908_();
            }
            if (hitResult.m_82434_().m_122434_() == Direction.Axis.Z) {
                this.shoot(vec3.f_82479_, vec3.f_82480_, this.m_20184_().m_82548_().f_82481_, 0.8f, 0.0f);
            }
            if (this.m_9236_().m_8055_(blockPos).m_204336_(SMBlockTags.PROJECTILES_BOUNCE_ON)) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SMSounds.JADE_RICOCHET.get(), this.m_5720_(), 1.0f, 0.0f);
                this.f_19804_.m_135381_(SPIN_TICKS, (Object)Mth.m_14045_((int)(this.getSpinTicksEntityData() + 20), (int)0, (int)30));
            }
        }
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (this.getSpinTicksEntityData() > 0) {
            this.hitShield(level.m_6249_((Entity)this, this.m_20191_().m_82400_(0.5), EntitySelector.f_20406_));
            this.hurtEntity(level.m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), EntitySelector.f_20406_));
            this.knockBack(level.m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), EntitySelector.f_20406_));
            this.blockKnockBack();
            this.f_19804_.m_135381_(SPIN_TICKS, (Object)(this.getSpinTicksEntityData() - 1));
            while (this.m_20184_().m_7096_() < -0.7 || this.m_20184_().m_7094_() < -0.7) {
                this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            }
            while (this.m_20184_().m_7096_() > 0.7 || this.m_20184_().m_7094_() > 0.7) {
                this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            }
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.handleJukeboxTick(this, level);
        if (!this.m_20068_()) {
            double yVelocity = -0.04;
            FluidType fluidType = this.getEyeInFluidType();
            if (fluidType != ForgeMod.EMPTY_TYPE.get()) {
                yVelocity *= this.getFluidMotionScale(fluidType);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, yVelocity, 0.0));
        }
        BlockPos bottomPosition = this.m_20099_();
        float friction = this.m_20096_() ? level.m_8055_(bottomPosition).getFriction((LevelReader)level, bottomPosition, (Entity)this) * 1.55f : 1.55f;
        float defaultFriction = this.m_9236_().m_8055_(bottomPosition).getFriction((LevelReader)level, bottomPosition, (Entity)this);
        double y = this.m_20184_().m_82507_(Direction.Axis.Y);
        if (y == -0.04 && !this.isInFluidType() && defaultFriction == 0.6f) {
            this.m_20256_(this.m_20184_().m_82542_((double)friction, 0.98, (double)friction));
        }
        if (this.isInFluidType()) {
            this.m_20256_(this.m_20184_().m_82542_(0.85, 1.0, 0.85));
        }
        if (this.m_20184_() != Vec3.f_82478_) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.m_20077_()) {
            this.m_20093_();
            this.f_19789_ *= 0.5f;
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        this.handleServerRemoval(this);
    }

    public void m_142036_() {
        if (!this.hasAppliedWorkstation() || !this.getRecordItem().m_41619_()) {
            // empty if block
        }
        super.m_142036_();
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("spinTicks", this.getSpinTicksEntityData().intValue());
        if (this.m_21805_() != null) {
            pCompound.m_128362_("Owner", this.m_21805_());
        }
        this.addSaveData(pCompound);
    }

    protected void m_7378_(CompoundTag pCompound) {
        UUID uuid;
        if (pCompound.m_128403_("Owner")) {
            uuid = pCompound.m_128342_("Owner");
        } else {
            String s = pCompound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)Objects.requireNonNull(this.m_20194_()), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
        this.readSaveData(pCompound);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setDamage(float pDamageTaken) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(pDamageTaken));
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtTime(int pHurtTime) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)pHurtTime);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setHurtDir(int pHurtDirection) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)pHurtDirection);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    @Override
    public ItemStack getAppliedWorkstation() {
        return (ItemStack)this.f_19804_.m_135370_(WORKSTATION);
    }

    @Override
    public void setAppliedWorkstation(ItemStack itemStack) {
        this.f_19804_.m_135381_(WORKSTATION, (Object)itemStack);
    }

    @Override
    public boolean hasAppliedWorkstation() {
        return !this.getAppliedWorkstation().m_41619_();
    }

    @Override
    public ItemStack getRecordItem() {
        return (ItemStack)this.f_19804_.m_135370_(RECORD_ITEM);
    }

    @Override
    public void setRecordItem(ItemStack itemStack) {
        this.f_19804_.m_135381_(RECORD_ITEM, (Object)itemStack);
    }

    @Override
    public long getRecordTickCount() {
        return this.f_19797_;
    }

    @Override
    public void setRecordTickCount(long tickCount) {
        this.recordTickCount = tickCount;
    }

    @Override
    public long getRecordStartedTick() {
        return this.recordStartedTick;
    }

    @Override
    public void setRecordStartedTick(long startedTick) {
        this.recordStartedTick = startedTick;
    }

    @Override
    public boolean isRecordPlaying() {
        return (Boolean)this.f_19804_.m_135370_(IS_RECORD_PLAYING);
    }

    @Override
    public void setRecordPlaying(boolean isPlaying) {
        this.f_19804_.m_135381_(IS_RECORD_PLAYING, (Object)isPlaying);
    }

    @Override
    public int getTicksSinceLastEvent() {
        return this.ticksSinceLastEvent;
    }

    @Override
    public void setTicksSinceLastEvent(int ticksSinceLastEvent) {
        this.ticksSinceLastEvent = ticksSinceLastEvent;
    }
}

