/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.core.other.tags.SMMobEffectTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class JungleSpider
extends Spider
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<String> BENEFICIAL_VENOM_EFFECT = SynchedEntityData.m_135353_(JungleSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> HARMFUL_VENOM_EFFECT = SynchedEntityData.m_135353_(JungleSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final List<MobEffect> BENEFICIAL_VENOM_EFFECTS = new ArrayList<MobEffect>();
    private static final List<MobEffect> HARMFUL_VENOM_EFFECTS = new ArrayList<MobEffect>();

    public JungleSpider(EntityType<? extends JungleSpider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.createEffectLists();
        this.f_19804_.m_135372_(BENEFICIAL_VENOM_EFFECT, (Object)Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.chooseBeneficialEffect())).toString());
        this.f_19804_.m_135372_(HARMFUL_VENOM_EFFECT, (Object)Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.chooseHarmfulEffect())).toString());
    }

    public static boolean checkJungleSpiderSpawnRules(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return Monster.m_219013_(pType, (ServerLevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public MobEffect getBeneficialVenomEffect() {
        return Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation((String)this.f_19804_.m_135370_(BENEFICIAL_VENOM_EFFECT))));
    }

    public MobEffect getHarmfulVenomEffect() {
        return Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation((String)this.f_19804_.m_135370_(HARMFUL_VENOM_EFFECT))));
    }

    public void setBeneficialVenomEffect(MobEffect mobEffect) {
        this.f_19804_.m_135381_(BENEFICIAL_VENOM_EFFECT, (Object)Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect)).toString());
    }

    public void setHarmfulVenomEffect(MobEffect mobEffect) {
        this.f_19804_.m_135381_(HARMFUL_VENOM_EFFECT, (Object)Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect)).toString());
    }

    public boolean isEffectExtended(MobEffect mobEffect) {
        return Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.tags()).getTag(SMMobEffectTags.EXTENDED_VENOM_EFFECTS).contains((Object)mobEffect);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getHarmfulVenomEffect() == MobEffects.f_19610_ && this.getBeneficialVenomEffect() == MobEffects.f_19611_) {
            this.setHarmfulVenomEffect(this.chooseHarmfulEffect());
        }
        if (this.getHarmfulVenomEffect() == MobEffects.f_19599_ && this.getBeneficialVenomEffect() == MobEffects.f_19598_) {
            this.setBeneficialVenomEffect(this.chooseBeneficialEffect());
        }
        if (this.getHarmfulVenomEffect() == MobEffects.f_19597_ && this.getBeneficialVenomEffect() == MobEffects.f_19596_) {
            this.setBeneficialVenomEffect(this.chooseBeneficialEffect());
        }
        if (this.getHarmfulVenomEffect() == null) {
            this.setHarmfulVenomEffect(this.chooseHarmfulEffect());
        }
        if (this.getBeneficialVenomEffect() == null) {
            this.setBeneficialVenomEffect(this.chooseHarmfulEffect());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public boolean m_7327_(Entity pEntity) {
        if (super.m_7327_(pEntity)) {
            if (pEntity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_().equals((Object)Difficulty.EASY)) {
                    i = 5;
                } else if (this.m_9236_().m_46791_().equals((Object)Difficulty.NORMAL)) {
                    i = 10;
                } else if (this.m_9236_().m_46791_().equals((Object)Difficulty.HARD)) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)pEntity).m_147207_(new MobEffectInstance(this.getHarmfulVenomEffect(), this.isEffectExtended(this.getHarmfulVenomEffect()) ? i * 20 + 5 : i * 20, 0), (Entity)this);
                    ((LivingEntity)pEntity).m_147207_(new MobEffectInstance(this.getBeneficialVenomEffect(), this.isEffectExtended(this.getBeneficialVenomEffect()) ? i * 20 + 5 : i * 20, 0), (Entity)this);
                }
            }
            return true;
        }
        return false;
    }

    public void createEffectLists() {
        ForgeRegistries.MOB_EFFECTS.iterator().forEachRemaining(mobEffect -> {
            if ((mobEffect.m_19483_() == MobEffectCategory.BENEFICIAL || mobEffect.m_19483_() == MobEffectCategory.NEUTRAL) && ((Holder)ForgeRegistries.MOB_EFFECTS.getHolder(ForgeRegistries.MOB_EFFECTS.getKey(mobEffect)).orElseThrow()).m_203656_(SMMobEffectTags.JUNGLE_SPIDER_BENEFICIAL_OR_NEUTRAL_VENOM_EFFECTS)) {
                BENEFICIAL_VENOM_EFFECTS.add((MobEffect)mobEffect);
            }
            if (mobEffect.m_19483_() == MobEffectCategory.HARMFUL && ((Holder)ForgeRegistries.MOB_EFFECTS.getHolder(ForgeRegistries.MOB_EFFECTS.getKey(mobEffect)).orElseThrow()).m_203656_(SMMobEffectTags.JUNGLE_SPIDER_HARMFUL_VENOM_EFFECTS)) {
                HARMFUL_VENOM_EFFECTS.add((MobEffect)mobEffect);
            }
        });
    }

    private MobEffect chooseBeneficialEffect() {
        return BENEFICIAL_VENOM_EFFECTS.get(this.f_19796_.m_188503_(BENEFICIAL_VENOM_EFFECTS.size()));
    }

    private MobEffect chooseHarmfulEffect() {
        return HARMFUL_VENOM_EFFECTS.get(this.f_19796_.m_188503_(HARMFUL_VENOM_EFFECTS.size()));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128359_("BeneficialEffect", (String)this.f_19804_.m_135370_(BENEFICIAL_VENOM_EFFECT));
        compoundTag.m_128359_("HarmfulEffect", (String)this.f_19804_.m_135370_(HARMFUL_VENOM_EFFECT));
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        MobEffect BENEFICIAL = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(compoundTag.m_128461_("BeneficialEffect")));
        MobEffect HARMFUL = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(compoundTag.m_128461_("HarmfulEffect")));
        this.setBeneficialVenomEffect(BENEFICIAL != null ? BENEFICIAL : this.chooseBeneficialEffect());
        this.setHarmfulVenomEffect(HARMFUL != null ? HARMFUL : this.chooseHarmfulEffect());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.getBeneficialVenomEffect())));
        buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.getHarmfulVenomEffect())));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setBeneficialVenomEffect(Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(additionalData.m_130281_())));
        this.setHarmfulVenomEffect(Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(additionalData.m_130281_())));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 0.45f;
    }
}

