/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.blocks.utilities;

import com.uraneptus.sullysmod.common.blocks.AmberLayeredCauldronBlock;
import com.uraneptus.sullysmod.core.other.tags.SMBlockTags;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AmberUtil {
    public static final BooleanProperty IS_MELTED = BooleanProperty.m_61465_((String)"is_melted");
    public static final VoxelShape MELTING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
    public static final Predicate<BlockState> AMBER_MELTING_BLOCKS = blockstate -> blockstate.m_204336_(SMBlockTags.MELTS_AMBER) && blockstate.m_60791_() >= 3;

    public static VoxelShape basicCollisionShapeUpdate(VoxelShape parentShape, BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext instanceof EntityCollisionContext) {
            EntityCollisionContext entitycollisioncontext = (EntityCollisionContext)pContext;
            Entity entity = entitycollisioncontext.m_193113_();
            if (entity instanceof Projectile) {
                return parentShape;
            }
            if (entity != null) {
                Level level = entity.m_9236_();
                boolean shouldMeltFlag = false;
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-1, -1, -1), (BlockPos)pPos.m_7918_(1, 1, 1))) {
                    BlockState state = pLevel.m_8055_(pos);
                    if (AMBER_MELTING_BLOCKS.test(state)) {
                        shouldMeltFlag = true;
                    }
                    if (!((Boolean)pState.m_61143_((Property)IS_MELTED)).booleanValue() || level.m_45517_(LightLayer.BLOCK, pPos.m_7494_()) < 9) continue;
                    shouldMeltFlag = true;
                }
                if (shouldMeltFlag) {
                    level.m_7731_(pPos, (BlockState)pState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(true)), 3);
                    return Shapes.m_83040_();
                }
            }
        }
        return parentShape;
    }

    public static void basicEntityInsideBehavior(Block instance, BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (((Boolean)pState.m_61143_((Property)IS_MELTED)).booleanValue() && (!(pEntity instanceof LivingEntity) || pEntity.m_146900_().m_60713_(instance))) {
            if (pEntity instanceof Player) {
                pEntity.m_7601_(pState, new Vec3((double)0.8f, 0.1, (double)0.8f));
            } else if (pEntity instanceof Mob) {
                Mob mob = (Mob)pEntity;
                if (mob.m_20160_()) {
                    mob.m_7601_(pState, new Vec3(0.5, 0.1, 0.5));
                } else {
                    mob.m_7601_(pState, new Vec3((double)0.8f, 0.1, (double)0.8f));
                }
            }
            if (pLevel.f_46443_) {
                boolean flag;
                RandomSource randomsource = pLevel.m_213780_();
                boolean bl = flag = pEntity.f_19790_ != pEntity.m_20185_() || pEntity.f_19792_ != pEntity.m_20189_();
                if (flag && randomsource.m_188499_()) {
                    pLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)SMBlocks.AMBER.get()).m_49966_()), pEntity.m_20185_(), (double)(pPos.m_123342_() + 1), pEntity.m_20189_(), (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f));
                }
            }
        }
    }

    public static void fillCauldronBehavior(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        BlockPos cauldronPos;
        if (((Boolean)pState.m_61143_((Property)IS_MELTED)).booleanValue() && (cauldronPos = AmberUtil.findFillableCauldronBelow((Level)pLevel, pPos)) != null) {
            AmberLayeredCauldronBlock amberCauldron;
            Block block;
            BlockState cauldronState = pLevel.m_8055_(cauldronPos);
            if (cauldronState.m_60713_(Blocks.f_50256_)) {
                BlockState blockstate = ((Block)SMBlocks.AMBER_CAULDRON.get()).m_49966_();
                pLevel.m_46597_(cauldronPos, blockstate);
                pLevel.m_220407_(GameEvent.f_157792_, cauldronPos, GameEvent.Context.m_223722_((BlockState)blockstate));
                pLevel.m_46796_(1047, cauldronPos, 0);
            }
            if ((block = cauldronState.m_60734_()) instanceof AmberLayeredCauldronBlock && !(amberCauldron = (AmberLayeredCauldronBlock)block).m_142596_(cauldronState)) {
                BlockState blockstate = (BlockState)cauldronState.m_61124_((Property)AmberLayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)cauldronState.m_61143_((Property)AmberLayeredCauldronBlock.LEVEL) + 1));
                pLevel.m_46597_(cauldronPos, blockstate);
                pLevel.m_220407_(GameEvent.f_157792_, cauldronPos, GameEvent.Context.m_223722_((BlockState)blockstate));
                pLevel.m_46796_(1047, cauldronPos, 0);
            }
        }
    }

    @Nullable
    private static BlockPos findFillableCauldronBelow(Level pLevel, BlockPos pPos) {
        Predicate<BlockState> predicate = state -> state.m_60713_(Blocks.f_50256_) || state.m_60713_((Block)SMBlocks.AMBER_CAULDRON.get());
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202034_, p_202035_) -> AmberUtil.canDripThrough((BlockGetter)pLevel, p_202034_, p_202035_);
        return AmberUtil.findBlockVertical((LevelAccessor)pLevel, pPos, Direction.DOWN.m_122421_(), bipredicate, predicate, 11).orElse(null);
    }

    private static boolean canDripThrough(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        if (pState.m_60795_()) {
            return true;
        }
        if (pState.m_60804_(pLevel, pPos)) {
            return false;
        }
        if (!pState.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelshape = pState.m_60812_(pLevel, pPos);
        return !Shapes.m_83157_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor pLevel, BlockPos pPos, Direction.AxisDirection pAxis, BiPredicate<BlockPos, BlockState> pPositionalStatePredicate, Predicate<BlockState> pStatePredicate, int pMaxIterations) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)pAxis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (int i = 1; i < pMaxIterations; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (pStatePredicate.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!pLevel.m_151562_(blockpos$mutableblockpos.m_123342_()) && pPositionalStatePredicate.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static void spawnAmberParticles(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)IS_MELTED)).booleanValue()) {
            for (int i = 0; i < pRandom.m_188503_(1) + 1; ++i) {
                if (pRandom.m_188503_(3) != 0) continue;
                AmberUtil.spawnParticlesOnBlockFaces(pLevel, pPos, (ParticleOptions)SMParticleTypes.AMBER_DRIPPING.get(), (IntProvider)UniformInt.m_146622_((int)0, (int)1));
            }
        }
    }

    private static void spawnParticlesOnBlockFaces(Level pLevel, BlockPos pPos, ParticleOptions pParticle, IntProvider pCount) {
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP || !pLevel.m_8055_(pPos.m_121945_(direction)).m_60795_()) continue;
            ParticleUtils.m_216318_((Level)pLevel, (BlockPos)pPos, (ParticleOptions)pParticle, (IntProvider)pCount, (Direction)direction, () -> new Vec3(Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.5, (double)0.5)), (double)0.55);
        }
    }
}

