/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.blocks;

import com.uraneptus.sullysmod.common.blockentities.AmberBE;
import com.uraneptus.sullysmod.common.blocks.utilities.AmberUtil;
import com.uraneptus.sullysmod.common.caps.SMEntityCap;
import com.uraneptus.sullysmod.common.networking.MsgEntityAmberStuck;
import com.uraneptus.sullysmod.common.networking.SMPacketHandler;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AmberBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty IS_MELTED = AmberUtil.IS_MELTED;

    public AmberBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.m_60713_((Block)this) || super.m_6104_(pState, pAdjacentBlockState, pSide);
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        AmberUtil.spawnAmberParticles(pState, pLevel, pPos, pRandom);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        AmberUtil.fillCauldronBehavior(pState, pLevel, pPos);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof AmberBE) {
            AmberBE amber = (AmberBE)blockEntity;
            if (pContext instanceof EntityCollisionContext) {
                EntityCollisionContext entitycollisioncontext = (EntityCollisionContext)pContext;
                Entity entity = entitycollisioncontext.m_193113_();
                if (entity instanceof Projectile) {
                    return Shapes.m_83144_();
                }
                Level level = blockEntity.m_58904_();
                if (level == null) {
                    return Shapes.m_83144_();
                }
                if (!amber.hasStuckEntity() && entity != null) {
                    BlockState state;
                    boolean shouldMeltFlag = false;
                    level.m_7731_(pPos, (BlockState)pState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(false)), 3);
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-1, -1, -1), (BlockPos)pPos.m_7918_(1, 1, 1))) {
                        state = pLevel.m_8055_(pos);
                        if (AmberUtil.AMBER_MELTING_BLOCKS.test(state)) {
                            shouldMeltFlag = true;
                        }
                        if (!state.m_61138_((Property)IS_MELTED) || !((Boolean)state.m_61143_((Property)IS_MELTED)).booleanValue() || level.m_45517_(LightLayer.BLOCK, pPos.m_7494_()) < 9) continue;
                        shouldMeltFlag = true;
                    }
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(0, -1, 0), (BlockPos)pPos.m_7918_(0, -2, 0))) {
                        CompoundTag compoundtag;
                        Entity entityLoaded;
                        AmberBE amberBE;
                        state = pLevel.m_8055_(pos);
                        BlockEntity be = pLevel.m_7702_(pos);
                        if (!state.m_60713_((Block)SMBlocks.AMBER.get()) || !(be instanceof AmberBE) || !(amberBE = (AmberBE)be).hasStuckEntity() || (entityLoaded = EntityType.m_20645_((CompoundTag)(compoundtag = amberBE.getEntityStuck()), (Level)level, entityStuck -> entityStuck)) == null) continue;
                        if (entityLoaded.m_20191_().m_82376_() > 1.5 && entityLoaded.m_20191_().m_82376_() < 2.0 && pos.equals((Object)pPos.m_7918_(0, -1, 0))) {
                            shouldMeltFlag = false;
                            continue;
                        }
                        if (!(entityLoaded.m_20191_().m_82376_() >= 2.0) || !(entityLoaded.m_20191_().m_82376_() < 3.5) || !pos.equals((Object)pPos.m_7918_(0, -2, 0))) continue;
                        shouldMeltFlag = false;
                    }
                    if (shouldMeltFlag) {
                        level.m_7731_(pPos, (BlockState)pState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(true)), 3);
                        return AmberUtil.MELTING_COLLISION_SHAPE;
                    }
                }
            }
        }
        return Shapes.m_83144_();
    }

    public void m_6810_(BlockState blockState, Level pLevel, BlockPos blockPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (blockState.m_60734_() == SMBlocks.AMBER.get() && (blockEntity = pLevel.m_7702_(blockPos)) instanceof AmberBE) {
            AmberBE amberBlockEntity = (AmberBE)blockEntity;
            if (amberBlockEntity.hasStuckEntity()) {
                CompoundTag compoundtag = amberBlockEntity.getEntityStuck();
                AmberBE.removeIgnoredNBT(compoundtag);
                Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)pLevel, entityLoaded -> entityLoaded);
                if (entity != null) {
                    SMEntityCap.getCapOptional(entity).ifPresent(cap -> {
                        cap.stuckInAmber = false;
                    });
                    SMPacketHandler.sendMsg(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), new MsgEntityAmberStuck(entity, false));
                    if (entity instanceof ItemEntity) {
                        entity.m_20334_(0.0, 0.0, 0.0);
                    }
                    entity.m_6027_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                    pLevel.m_7967_(entity);
                }
            }
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(0, -1, 0), (BlockPos)blockPos.m_7918_(0, -2, 0))) {
                AmberBE amberBE;
                BlockState state = pLevel.m_8055_(pos);
                BlockEntity be = pLevel.m_7702_(pos);
                if (!state.m_60713_((Block)SMBlocks.AMBER.get()) || !(be instanceof AmberBE) || !(amberBE = (AmberBE)be).hasStuckEntity()) continue;
                CompoundTag compoundtag = amberBE.getEntityStuck();
                AmberBE.removeIgnoredNBT(compoundtag);
                Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)pLevel, entityStuck -> entityStuck);
                if (entity == null) continue;
                SMEntityCap.getCapOptional(entity).ifPresent(cap -> {
                    cap.stuckInAmber = false;
                });
                SMPacketHandler.sendMsg(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), new MsgEntityAmberStuck(entity, false));
                if (entity.m_20191_().m_82376_() > 1.5 && entity.m_20191_().m_82376_() < 2.0 && pos.equals((Object)blockPos.m_7918_(0, -1, 0))) {
                    pLevel.m_7731_(pos, (BlockState)blockState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(false)), 3);
                    entity.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                    pLevel.m_7967_(entity);
                    amberBE.setStuckEntityData(null);
                    continue;
                }
                if (!(entity.m_20191_().m_82376_() >= 2.0) || !(entity.m_20191_().m_82376_() < 3.5)) continue;
                pLevel.m_7731_(pos, (BlockState)blockState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(false)), 3);
                entity.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                pLevel.m_7967_(entity);
                amberBE.setStuckEntityData(null);
            }
        }
        super.m_6810_(blockState, pLevel, blockPos, pNewState, pIsMoving);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        AmberBE amber;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof AmberBE && !(amber = (AmberBE)blockEntity).hasStuckEntity() && ((Boolean)pState.m_61143_((Property)IS_MELTED)).booleanValue() && (!(pEntity instanceof LivingEntity) || pEntity.m_146900_().m_60713_((Block)this))) {
            if (pEntity instanceof Player) {
                pEntity.m_7601_(pState, new Vec3((double)0.8f, 0.1, (double)0.8f));
            }
            if (pEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)pEntity;
                itemEntity.m_7601_(pState, new Vec3(0.0, 0.1, 0.0));
                if (itemEntity.m_20096_()) {
                    amber.makeEntityStuck((Entity)itemEntity);
                }
            } else if (pEntity instanceof Mob) {
                Mob mob = (Mob)pEntity;
                if (mob.m_20160_()) {
                    mob.m_7601_(pState, new Vec3(0.5, 0.1, 0.5));
                } else if (mob.m_20191_().m_82376_() < 1.5) {
                    mob.m_7601_(pState, new Vec3(0.0, 0.1, 0.0));
                    if (mob.m_20096_()) {
                        amber.makeEntityStuck((Entity)mob);
                    }
                } else if (mob.m_20191_().m_82376_() < 2.0) {
                    BlockPos extendedPos = new BlockPos(mob.m_146903_(), mob.m_146904_() + 1, mob.m_146907_());
                    if (pLevel.m_8055_(extendedPos).m_60713_((Block)SMBlocks.AMBER.get())) {
                        mob.m_7601_(pState, new Vec3(0.0, 0.1, 0.0));
                        if (mob.m_20096_()) {
                            pLevel.m_7731_(extendedPos, (BlockState)pState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(false)), 3);
                            amber.makeEntityStuck((Entity)mob);
                        }
                    } else {
                        mob.m_7601_(pState, new Vec3((double)0.8f, 0.1, (double)0.8f));
                    }
                } else if (mob.m_20191_().m_82376_() < 3.5) {
                    BlockPos extendedPos = new BlockPos(mob.m_146903_(), mob.m_146904_() + 1, mob.m_146907_());
                    BlockPos extendedPos1 = new BlockPos(mob.m_146903_(), mob.m_146904_() + 2, mob.m_146907_());
                    if (pLevel.m_8055_(extendedPos).m_60713_((Block)SMBlocks.AMBER.get()) && pLevel.m_8055_(extendedPos1).m_60713_((Block)SMBlocks.AMBER.get())) {
                        mob.m_7601_(pState, new Vec3(0.0, 0.1, 0.0));
                        if (mob.m_20096_()) {
                            pLevel.m_7731_(extendedPos, (BlockState)pState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(false)), 3);
                            pLevel.m_7731_(extendedPos1, (BlockState)pState.m_61124_((Property)IS_MELTED, (Comparable)Boolean.valueOf(false)), 3);
                            amber.makeEntityStuck((Entity)mob);
                        }
                    } else {
                        mob.m_7601_(pState, new Vec3((double)0.8f, 0.1, (double)0.8f));
                    }
                } else {
                    mob.m_7601_(pState, new Vec3((double)0.8f, 0.1, (double)0.8f));
                }
            }
            if (pLevel.f_46443_) {
                boolean flag;
                RandomSource randomsource = pLevel.m_213780_();
                boolean bl = flag = pEntity.f_19790_ != pEntity.m_20185_() || pEntity.f_19792_ != pEntity.m_20189_();
                if (flag && randomsource.m_188499_()) {
                    pLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)SMBlocks.AMBER.get()).m_49966_()), pEntity.m_20185_(), (double)(pPos.m_123342_() + 1), pEntity.m_20189_(), (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f));
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{IS_MELTED});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (level1, pos, state1, tile) -> ((AmberBE)tile).tick();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AmberBE(pPos, pState);
    }
}

