/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.blockentities;

import com.uraneptus.sullysmod.common.blocks.FlingerTotem;
import com.uraneptus.sullysmod.core.registry.SMBlockEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class FlingerTotemBE
extends BlockEntity {
    private static final List<String> IGNORED_NBT = List.of("UUID");
    private final List<ProjectileData> stored = new ObjectArrayList();

    public FlingerTotemBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SMBlockEntityTypes.FLINGER_TOTEM.get(), pPos, pBlockState);
    }

    public void addProjectile(Projectile projectile) {
        if (this.stored.size() < 5) {
            CompoundTag compoundtag = new CompoundTag();
            projectile.m_20223_(compoundtag);
            this.storeProjectile(compoundtag, this.calculateDelayFromHoney());
            if (this.f_58857_ != null) {
                BlockPos blockpos = this.m_58899_();
                if ((Integer)this.m_58900_().m_61143_((Property)FlingerTotem.HONEY_AMOUNT) != 0) {
                    this.f_58857_.m_6263_(null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (SoundEvent)SMSounds.FLINGER_INPUT_HONEY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.f_58857_.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)projectile, (BlockState)this.m_58900_()));
            }
            projectile.m_146870_();
            super.m_6596_();
        }
    }

    private int calculateDelayFromHoney() {
        int honey = (Integer)this.m_58900_().m_61143_((Property)FlingerTotem.HONEY_AMOUNT);
        return 20 * honey;
    }

    public void storeProjectile(CompoundTag pEntityData, int delayTicks) {
        this.stored.add(new ProjectileData(pEntityData, delayTicks));
    }

    private static boolean outputProjectile(Level pLevel, BlockPos pPos, BlockState pState, ProjectileData pData) {
        Direction front = (Direction)pState.m_61143_((Property)FlingerTotem.FACING);
        CompoundTag compoundtag = pData.entityData.m_6426_();
        FlingerTotemBE.removeIgnoredNBT(compoundtag);
        Direction direction = (Direction)pState.m_61143_((Property)FlingerTotem.FACING);
        BlockPos blockpos = pPos.m_121945_(direction);
        if (!pLevel.m_8055_(blockpos).m_60812_((BlockGetter)pLevel, blockpos).m_83281_()) {
            return false;
        }
        Projectile projectile = (Projectile)EntityType.m_20645_((CompoundTag)compoundtag, (Level)pLevel, entity -> entity);
        if (projectile != null) {
            projectile.m_6027_((double)pPos.m_123341_() + 0.5 + (double)front.m_122429_(), (double)((float)pPos.m_123342_() + 0.5f + (float)front.m_122430_()), (double)pPos.m_123343_() + 0.5 + (double)front.m_122431_());
            projectile.m_6686_((double)front.m_122429_(), (double)front.m_122430_(), (double)front.m_122431_(), (float)projectile.m_20184_().m_82553_(), 0.0f);
            projectile.m_146850_(GameEvent.f_157778_);
            pLevel.m_5594_(null, pPos, (SoundEvent)SMSounds.FLINGER_FLINGS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return pLevel.m_7967_((Entity)projectile);
        }
        return false;
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, FlingerTotemBE pBlockEntity) {
        boolean flag = false;
        Iterator<ProjectileData> iterator = pBlockEntity.stored.iterator();
        while (iterator.hasNext()) {
            ProjectileData projectileData = iterator.next();
            if (projectileData.delayTicks <= 0 && FlingerTotemBE.outputProjectile(pLevel, pPos, pState, projectileData)) {
                flag = true;
                iterator.remove();
            }
            --projectileData.delayTicks;
        }
        if (flag) {
            FlingerTotemBE.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    static void removeIgnoredNBT(CompoundTag pTag) {
        for (String s : IGNORED_NBT) {
            pTag.m_128473_(s);
        }
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 5;
    }

    @Nonnull
    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)SMBlockEntityTypes.FLINGER_TOTEM.get();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        ListTag listtag = pTag.m_128437_("Projectiles", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ProjectileData projectileData = new ProjectileData(compoundtag.m_128469_("EntityData"), compoundtag.m_128451_("DelayTicks"));
            this.stored.add(projectileData);
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Projectiles", (Tag)this.writeProjectiles());
    }

    public ListTag writeProjectiles() {
        ListTag listtag = new ListTag();
        for (ProjectileData projectileData : this.stored) {
            CompoundTag compoundtag = projectileData.entityData.m_6426_();
            compoundtag.m_128473_("UUID");
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_("EntityData", (Tag)compoundtag);
            compoundtag1.m_128405_("DelayTicks", projectileData.delayTicks);
            listtag.add((Object)compoundtag1);
        }
        return listtag;
    }

    static class ProjectileData {
        final CompoundTag entityData;
        int delayTicks;

        ProjectileData(CompoundTag pEntityData, int delayTicks) {
            FlingerTotemBE.removeIgnoredNBT(pEntityData);
            this.entityData = pEntityData;
            this.delayTicks = delayTicks;
        }
    }
}

