/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.blockentities;

import com.uraneptus.sullysmod.common.blocks.utilities.AmberUtil;
import com.uraneptus.sullysmod.common.caps.SMEntityCap;
import com.uraneptus.sullysmod.common.networking.MsgEntityAmberStuck;
import com.uraneptus.sullysmod.common.networking.SMPacketHandler;
import com.uraneptus.sullysmod.core.registry.SMBlockEntityTypes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class AmberBE
extends BlockEntity {
    @Nullable
    private StuckEntityData stuckEntityData;
    public boolean renderEntity;
    private boolean entityUpdated = false;
    private static final List<String> IGNORED_NBT = Arrays.asList("Leash", "Fire");

    public AmberBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SMBlockEntityTypes.AMBER.get(), pPos, pBlockState);
    }

    public static void removeIgnoredNBT(CompoundTag pTag) {
        for (String s : IGNORED_NBT) {
            pTag.m_128473_(s);
        }
    }

    public void setStuckEntityData(@Nullable StuckEntityData value) {
        this.stuckEntityData = value;
        this.renderEntity = value != null;
        this.update();
    }

    public boolean hasStuckEntity() {
        return this.stuckEntityData != null;
    }

    public CompoundTag getEntityStuck() {
        CompoundTag tag = new CompoundTag();
        return this.stuckEntityData != null ? this.stuckEntityData.entityData : tag;
    }

    public void makeEntityStuck(Entity entity) {
        if (this.stuckEntityData != null) {
            return;
        }
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        level.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AmberUtil.IS_MELTED, (Comparable)Boolean.valueOf(false)), 3);
        CompoundTag compoundtag = new CompoundTag();
        SMPacketHandler.sendMsg(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), new MsgEntityAmberStuck(entity, true));
        SMEntityCap.getCapOptional(entity).ifPresent(cap -> {
            cap.stuckInAmber = true;
        });
        entity.m_20223_(compoundtag);
        if (!compoundtag.m_128456_()) {
            this.storeEntity(compoundtag);
        }
        this.renderEntity = true;
        this.entityUpdated = true;
        this.update();
        entity.m_146870_();
    }

    public boolean storeTypeForGeneration(EntityType<?> entityType) {
        String id;
        if (this.stuckEntityData != null) {
            return false;
        }
        CompoundTag compoundtag = new CompoundTag();
        ResourceLocation resourcelocation = EntityType.m_20613_(entityType);
        String string = id = entityType.m_20584_() ? resourcelocation.toString() : null;
        if (id == null) {
            return false;
        }
        compoundtag.m_128359_("id", id);
        this.storeEntity(compoundtag);
        return true;
    }

    public void storeEntity(CompoundTag pEntityData) {
        this.stuckEntityData = new StuckEntityData(pEntityData);
    }

    public void tick() {
        Entity entity;
        CompoundTag stuckEntity = this.getEntityStuck();
        if (stuckEntity.m_128456_() || this.entityUpdated || this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_5776_() && (entity = EntityType.m_20645_((CompoundTag)stuckEntity, (Level)this.f_58857_, Function.identity())) != null) {
            entity.m_5618_(Mth.m_216283_((RandomSource)this.f_58857_.f_46441_, (float)1.0f, (float)270.0f));
            this.stuckEntityData = null;
            this.makeEntityStuck(entity);
        }
    }

    public void update() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nonnull
    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)SMBlockEntityTypes.AMBER.get();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("StuckEntity", (Tag)this.writeStuckEntity());
        pTag.m_128379_("RenderEntity", this.renderEntity);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        ListTag listtag = pTag.m_128437_("StuckEntity", 10);
        if (!listtag.isEmpty()) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                this.stuckEntityData = new StuckEntityData(compoundtag.m_128469_("EntityData"));
            }
        } else {
            this.stuckEntityData = null;
        }
        this.renderEntity = pTag.m_128471_("RenderEntity");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("StuckEntity", (Tag)this.writeStuckEntity());
        tag.m_128379_("RenderEntity", this.renderEntity);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ListTag writeStuckEntity() {
        ListTag listtag = new ListTag();
        if (this.stuckEntityData != null) {
            CompoundTag entityDataTag = this.stuckEntityData.entityData.m_6426_();
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_("EntityData", (Tag)entityDataTag);
            listtag.add((Object)compoundtag1);
        }
        return listtag;
    }

    public static class StuckEntityData {
        final CompoundTag entityData;

        StuckEntityData(CompoundTag pEntityData) {
            AmberBE.removeIgnoredNBT(pEntityData);
            this.entityData = pEntityData;
        }
    }
}

