/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.client.particles;

import com.uraneptus.sullysmod.core.registry.SMFluids;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AmberParticle
extends TextureSheetParticle {
    private final Fluid type;

    public AmberParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ);
        this.m_107250_(0.01f, 0.01f);
        this.type = (Fluid)SMFluids.SOURCE_MOLTEN_AMBER.get();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                BlockPos blockpos;
                FluidState fluidstate;
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                if (this.type != Fluids.f_76191_ && (fluidstate = this.f_107208_.m_6425_(blockpos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_))).m_76152_() == this.type && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    public static TextureSheetParticle createAmberHangParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        return new AmberHangParticle(pLevel, pX, pY, pZ);
    }

    public static TextureSheetParticle createAmberFallParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        return new AmberFallAndLandParticle(pLevel, pX, pY, pZ);
    }

    public static TextureSheetParticle createAmberLandParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        return new DripLandParticle(pLevel, pX, pY, pZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AmberHangParticle
    extends AmberParticle {
        private final ParticleOptions fallingParticle = (ParticleOptions)SMParticleTypes.AMBER_FALL.get();

        AmberHangParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
            super(pLevel, pX, pY, pZ);
            this.f_107226_ *= 0.01f;
            this.f_107225_ = 100;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.fallingParticle, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AmberFallAndLandParticle
    extends AmberParticle {
        protected final ParticleOptions landParticle = (ParticleOptions)SMParticleTypes.AMBER_LAND.get();

        AmberFallAndLandParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
            super(pLevel, pX, pY, pZ);
            this.f_107226_ = 0.01f;
            this.f_107225_ = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_ + 0.14, this.f_107214_, 0.0, 0.0, 0.0);
                float f = Mth.m_216283_((RandomSource)this.f_107223_, (float)0.3f, (float)1.0f);
                this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)SMSounds.AMBER_DRIP.get(), SoundSource.BLOCKS, f, 1.0f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripLandParticle
    extends AmberParticle {
        DripLandParticle(ClientLevel p_106102_, double p_106103_, double p_106104_, double p_106105_) {
            super(p_106102_, p_106103_, p_106104_, p_106105_);
            this.f_107225_ = (int)(128.0 / (Math.random() * 0.8 + 0.2));
            this.f_107219_ = false;
        }
    }
}

