/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.client.animations;

import com.uraneptus.sullysmod.client.model.RootModel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class AnimUtil {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public static <M extends EntityModel<?>> void animate(M model, AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks) {
        AnimUtil.animate(model, pAnimationState, pAnimationDefinition, pAgeInTicks, 1.0f);
    }

    public static <M extends EntityModel<?>> void animateWalk(M model, AnimationDefinition pAnimationDefinition, float pLimbSwing, float pLimbSwingAmount, float pMaxAnimationSpeed, float pAnimationScaleFactor) {
        long i = (long)(pLimbSwing * 50.0f * pMaxAnimationSpeed);
        float f = Math.min(pLimbSwingAmount * pAnimationScaleFactor, 1.0f);
        AnimUtil.animate(model, pAnimationDefinition, i, f, ANIMATION_VECTOR_CACHE);
    }

    public static <M extends EntityModel<?>> void animate(M model, AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks, float pSpeed) {
        pAnimationState.m_216974_(pAgeInTicks, pSpeed);
        pAnimationState.m_216979_(p_233392_ -> AnimUtil.animate(model, pAnimationDefinition, p_233392_.m_216981_(), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    public static <M extends EntityModel<?>> void animate(M model, AnimationDefinition pAnimationDefinition, long pAccumulatedTime, float pScale, Vector3f pAnimationVecCache) {
        float f = AnimUtil.getElapsedSeconds(pAnimationDefinition, pAccumulatedTime);
        for (Map.Entry entry : pAnimationDefinition.f_232257_().entrySet()) {
            Optional<ModelPart> optional = AnimUtil.getAnyDescendantWithName(model, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.f_232212_();
                int i = Math.max(0, Mth.m_14049_((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].f_232283_()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.f_232283_();
                float f2 = j != i ? Mth.m_14036_((float)(f1 / (keyframe1.f_232283_() - keyframe.f_232283_())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.f_232285_().m_232222_(pAnimationVecCache, f2, akeyframe, i, j, pScale);
                p_288241_.f_232211_().m_232247_(p_232330_, pAnimationVecCache);
            }));
        }
    }

    private static <M extends EntityModel<?>> Optional<ModelPart> getAnyDescendantWithName(M model, String pName) {
        return pName.equals("root") ? Optional.of(((RootModel)model).root()) : ((RootModel)model).root().m_171331_().filter(p_233400_ -> p_233400_.m_233562_(pName)).findFirst().map(p_233397_ -> p_233397_.m_171324_(pName));
    }

    private static float getElapsedSeconds(AnimationDefinition pAnimationDefinition, long pAccumulatedTime) {
        float f = (float)pAccumulatedTime / 1000.0f;
        return pAnimationDefinition.f_232256_() ? f % pAnimationDefinition.f_232255_() : f;
    }
}

