/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.expiration;

import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.expiration.ObjectExpirationHandler;
import xaero.pac.common.server.info.ServerInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;

public final class PartyExpirationHandler
extends ObjectExpirationHandler<ServerParty, PartyManager> {
    private final MinecraftServer server;

    protected PartyExpirationHandler(ServerInfo serverInfo, MinecraftServer server, PartyManager manager, long liveCheckInterval, long expirationTime, String checkingMessage) {
        super(serverInfo, manager, liveCheckInterval, expirationTime, checkingMessage);
        this.server = server;
    }

    @Override
    protected void handle(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        if (!((Boolean)ServerConfig.CONFIG.partiesEnabled.get()).booleanValue()) {
            return;
        }
        super.handle(serverData);
    }

    @Override
    public void preExpirationCheck(ServerParty party) {
    }

    @Override
    public boolean checkIfActive(ServerParty party) {
        return party.getOnlineMemberStream().findFirst().isPresent();
    }

    @Override
    public boolean expire(ServerParty party, IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        ((PartyManager)this.manager).removeTypedParty(party);
        this.onElementExpirationDone();
        return false;
    }

    public static final class Builder
    extends ObjectExpirationHandler.Builder<ServerParty, PartyManager, Builder> {
        private MinecraftServer server;

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setServer(null);
            this.setCheckingMessage("Checking for expired parties...");
            this.setExpirationTime((long)((Integer)ServerConfig.CONFIG.partyExpirationTime.get()).intValue() * 60L * 60L * 1000L);
            this.setLiveCheckInterval((long)((Integer)ServerConfig.CONFIG.partyExpirationCheckInterval.get()).intValue() * 60000L);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public PartyExpirationHandler build() {
            if (this.server == null) {
                throw new IllegalStateException();
            }
            return (PartyExpirationHandler)super.build();
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }

        @Override
        protected ObjectExpirationHandler<ServerParty, PartyManager> buildInternally() {
            return new PartyExpirationHandler(this.serverInfo, this.server, (PartyManager)this.manager, this.liveCheckInterval, this.expirationTime, this.checkingMessage);
        }
    }
}

