/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.IPacketHandler;
import xaero.pac.common.packet.PacketConsumerForge;

public class PacketHandlerForge
implements IPacketHandler {
    private static final String PROTOCOL_VERSION = "1.4.0";
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)OpenPartiesAndClaims.MAIN_CHANNEL_LOCATION, () -> "1.4.0", (Predicate)NetworkRegistry.acceptMissingOr((String)"1.4.0"), (Predicate)NetworkRegistry.acceptMissingOr((String)"1.4.0"));

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, P> decoder, BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        PacketConsumerForge<P> consumer = new PacketConsumerForge<P>(serverHandler, clientHandler);
        if (serverHandler == null != (clientHandler == null)) {
            NETWORK.registerMessage(index, type, encoder, decoder, consumer, Optional.of(clientHandler != null ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER));
        } else {
            NETWORK.registerMessage(index, type, encoder, decoder, consumer);
        }
    }

    public void sendToServer(Object packet) {
        NETWORK.sendToServer(packet);
    }

    public void sendToPlayer(ServerPlayer player, Object packet) {
        NETWORK.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

