/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.network.server;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import subaraki.paintings.network.IPacketBase;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.network.ProcessServerPacket;
import subaraki.paintings.network.client.CPacketPaintingUpdate;

public class SPacketPainting
implements IPacketBase {
    private ResourceLocation variantName;
    private BlockPos pos;
    private Direction face;

    public SPacketPainting() {
    }

    public SPacketPainting(ResourceLocation name, BlockPos pos, Direction face) {
        this.variantName = name;
        this.pos = pos;
        this.face = face;
    }

    public SPacketPainting(FriendlyByteBuf buff) {
        this.decode(buff);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.variantName.toString());
        buf.m_130064_(this.pos);
        buf.m_130070_(this.face.m_122433_());
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.variantName = new ResourceLocation(buf.m_130136_(256));
        this.pos = buf.m_130135_();
        this.face = Direction.m_122402_((String)buf.m_130136_(256));
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)context.get()).getSender();
            if (serverPlayer != null) {
                ProcessServerPacket.handle(serverPlayer.m_9236_(), serverPlayer, this.pos, this.face, this.variantName, (painting, player) -> NetworkHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new CPacketPaintingUpdate(painting, this.variantName)));
            }
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, SPacketPainting.class, SPacketPainting::encode, SPacketPainting::new, SPacketPainting::handle);
    }
}

