/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.network.client;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import subaraki.paintings.gui.PaintingScreen;
import subaraki.paintings.network.IPacketBase;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.network.ProcessClientPacket;

public class CPacketPaintingScreen
implements IPacketBase {
    private String[] resLocNames;
    private BlockPos pos;
    private Direction face;

    public CPacketPaintingScreen() {
    }

    public CPacketPaintingScreen(BlockPos pos, Direction face, ResourceLocation[] resLocs) {
        this.pos = pos;
        this.face = face;
        this.resLocNames = (String[])Arrays.stream(resLocs).map(ResourceLocation::toString).toArray(String[]::new);
    }

    public CPacketPaintingScreen(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.face.m_122433_());
        buf.writeInt(this.resLocNames.length);
        Arrays.stream(this.resLocNames).forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.face = Direction.m_122402_((String)buf.m_130277_());
        this.resLocNames = new String[buf.readInt()];
        for (int i = 0; i < this.resLocNames.length; ++i) {
            this.resLocNames[i] = buf.m_130277_();
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ProcessClientPacket.openScreen(this.pos, this.face, this.resLocNames, PaintingScreen::new));
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, CPacketPaintingScreen.class, CPacketPaintingScreen::encode, CPacketPaintingScreen::new, CPacketPaintingScreen::handle);
    }
}

