/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.event;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import subaraki.paintings.mixin.IPaintingAccessor;
import subaraki.paintings.network.supplier.SyncpacketSupplier;
import subaraki.paintings.utils.PaintingUtility;
import subaraki.paintings.utils.Services;

public class ProcessInteractEvent {
    private static boolean equalSizes(PaintingVariant a, PaintingVariant b) {
        return a.m_218908_() == b.m_218908_() && a.m_218909_() == b.m_218909_();
    }

    private static boolean equalNames(PaintingVariant a, PaintingVariant b) {
        return BuiltInRegistries.f_257051_.m_7981_((Object)a).equals((Object)BuiltInRegistries.f_257051_.m_7981_((Object)b));
    }

    public static boolean processInteractPainting(Player player, Entity target, InteractionHand hand, SyncpacketSupplier syncpacketSupplier) {
        if (Services.CONFIG.getCyclePaintings() && target instanceof Painting) {
            ServerPlayer serverPlayer;
            Painting painting = (Painting)target;
            if (hand.equals((Object)InteractionHand.MAIN_HAND) && player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_21120_(hand).m_41720_().equals(Items.f_42487_)) {
                Holder original = painting.m_28554_();
                Holder.Reference firstMatch = null;
                Holder.Reference newArt = null;
                List<ResourceLocation> validArtsArray = BuiltInRegistries.f_257051_.m_6566_().stream().filter(paintingRegistryName -> PaintingUtility.ART_COMPARATOR.compare((PaintingVariant)BuiltInRegistries.f_257051_.m_7745_(paintingRegistryName), (PaintingVariant)original.m_203334_()) == 0).toList();
                boolean takeNext = false;
                for (ResourceLocation registryName : validArtsArray) {
                    PaintingVariant variant = (PaintingVariant)BuiltInRegistries.f_257051_.m_7745_(registryName);
                    Optional regEntry = BuiltInRegistries.f_257051_.m_7854_((Object)variant);
                    if (ProcessInteractEvent.equalSizes((PaintingVariant)original.m_203334_(), variant) && regEntry.isPresent()) {
                        if (firstMatch == null) {
                            firstMatch = BuiltInRegistries.f_257051_.m_246971_((ResourceKey)regEntry.get());
                        }
                        if (takeNext) {
                            newArt = BuiltInRegistries.f_257051_.m_246971_((ResourceKey)regEntry.get());
                            break;
                        }
                        if (!ProcessInteractEvent.equalNames((PaintingVariant)original.m_203334_(), variant)) continue;
                        takeNext = true;
                        continue;
                    }
                    if (!takeNext) continue;
                    newArt = firstMatch;
                    break;
                }
                if (newArt == null && takeNext) {
                    newArt = firstMatch;
                }
                if (newArt != null) {
                    ((IPaintingAccessor)painting).callSetVariant((Holder<PaintingVariant>)newArt);
                    syncpacketSupplier.send(painting, serverPlayer);
                    return true;
                }
            }
        }
        return false;
    }
}

