/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class PendantItem
extends WearableArtifactItem {
    private final Supplier<Double> strikeChance;
    private final Supplier<Integer> cooldown;
    public static final List<BiConsumer<LivingEntity, Entity>> LISTENERS = new ArrayList<BiConsumer<LivingEntity, Entity>>();

    public PendantItem(Supplier<Double> strikeChance, Supplier<Integer> cooldown) {
        LISTENERS.add(this::onLivingHurt);
        this.strikeChance = strikeChance;
        this.cooldown = cooldown;
    }

    public double getStrikeChance() {
        return this.strikeChance.get();
    }

    protected void onLivingHurt(LivingEntity entity, Entity attacker) {
        if (this.isEquippedBy(entity) && !entity.m_9236_().m_5776_() && attacker != null && !this.isOnCooldown(entity) && entity.m_217043_().m_188500_() < this.getStrikeChance() && attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            this.applyEffect(entity, livingEntity);
            this.addCooldown(entity, this.cooldown.get());
        }
    }

    protected abstract void applyEffect(LivingEntity var1, LivingEntity var2);

    @Override
    protected boolean hasNonCosmeticEffects() {
        return this.getStrikeChance() > 0.0;
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_11673_;
    }
}

