/*
 * Decompiled with CFR 0.152.
 */
package com.dusk.event;

import com.dusk.Dusk;
import com.dusk.config.CommonConfiguration;
import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EventHandler {
    private static int tickCounter = 0;
    private static double spawnModifier = 1.0;
    private static final int RAISE_START = 12000;
    private static final int RAISE_STOP = 16000;
    private static final int DROP_START = 20000;
    private static final double INTERVAL = 20000.0;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.level.m_5776_() || event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.level.m_46472_() != Level.f_46428_) {
            return;
        }
        if (++tickCounter != 20) {
            return;
        }
        tickCounter = 0;
        EventHandler.adjustSpawnModifier(event.level.m_46468_() % 24000L);
    }

    private static void adjustClassification() {
        MobCategory.MONSTER.f_21586_ = (int)((double)((CommonConfiguration)Dusk.config.getCommonConfig()).baseMonsterCap * spawnModifier);
    }

    private static void adjustSpawnModifier(long time) {
        if (time <= 16000L && time >= 12000L) {
            spawnModifier += (double)((CommonConfiguration)Dusk.config.getCommonConfig()).nightSpawnMod / 20000.0;
            EventHandler.adjustClassification();
        } else if (spawnModifier > 1.0 && (time > 20000L || time < 12000L)) {
            spawnModifier -= (double)((CommonConfiguration)Dusk.config.getCommonConfig()).nightSpawnMod / 20000.0;
            spawnModifier = Math.max(spawnModifier, 1.0);
            EventHandler.adjustClassification();
        }
    }

    public static void onPlayerSleep(ServerPlayer serverPlayerEntity, BlockPos pos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> cir) {
        if (((CommonConfiguration)Dusk.config.getCommonConfig()).disableSleep || serverPlayerEntity.m_9236_().m_46468_() % 24000L < (long)((CommonConfiguration)Dusk.config.getCommonConfig()).minSleepTime) {
            cir.setReturnValue((Object)Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW));
        }
    }
}

