/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.AdvFramesClient;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlock;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StatFrameBlock
extends BaseFrameBlock {
    protected static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)0.0, (double)15.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_UP = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)14.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)1.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;

    public StatFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TRIGGERED});
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)TRIGGERED), 2);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return null;
        }
        return Utils.getTicker(blockEntityType, AdvFrames.STAT_FRAME_TILE.get(), StatFrameBlockTile::tick);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext p_60558_) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof StatFrameBlockTile) {
            StatFrameBlockTile tile = (StatFrameBlockTile)blockEntity;
            if (tile.getStat() == null) {
                AdvFramesClient.setStatScreen(tile, player);
            } else {
                GameProfile owner = tile.getOwner();
                if (owner != null && owner.getName() != null) {
                    Stat<?> stat = tile.getStat();
                    MutableComponent name = Component.m_237113_((String)owner.getName()).m_130940_(ChatFormatting.GOLD);
                    MutableComponent title = StatFrameBlock.getStatComponent(stat);
                    MutableComponent number = Component.m_237113_((String)stat.m_12860_(tile.getValue())).m_130940_(ChatFormatting.DARK_RED);
                    player.m_5661_((Component)Component.m_237110_((String)"advancementframes.message.stat", (Object[])new Object[]{title, name, number}), true);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StatFrameBlockTile(pos, state);
    }

    public static MutableComponent getStatComponent(Stat<?> stat) {
        MutableComponent text;
        StatType type = stat.m_12859_();
        Object value = stat.m_12867_();
        ResourceLocation statId = BuiltInRegistries.f_256899_.m_7981_((Object)type);
        if (value instanceof ItemLike) {
            ItemLike i = (ItemLike)value;
            text = Component.m_237110_((String)("stat.advancementframes." + statId.m_135815_()), (Object[])new Object[]{i.m_5456_().m_41466_().getString()});
        } else if (value instanceof EntityType) {
            EntityType e = (EntityType)value;
            text = Component.m_237110_((String)("stat.advancementframes." + statId.m_135815_()), (Object[])new Object[]{e.m_20676_().getString()});
        } else if (value instanceof ResourceLocation) {
            String string = stat.m_12867_().toString();
            text = Component.m_237115_((String)("stat." + string.replace(':', '.')));
        } else {
            text = Component.m_237113_((String)"Unsupported Stat");
        }
        return text;
    }
}

