/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.common.entity.animal;

import com.teamabnormals.autumnity.core.other.AutumnityCriteriaTriggers;
import com.teamabnormals.autumnity.core.other.tags.AutumnityBlockTags;
import com.teamabnormals.autumnity.core.other.tags.AutumnityItemTags;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import com.teamabnormals.autumnity.core.registry.AutumnitySoundEvents;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Snail
extends Animal {
    private static final UUID HIDING_ARMOR_BONUS_ID = UUID.fromString("73BF0604-4235-4D4C-8A74-6A633E526E24");
    private static final AttributeModifier HIDING_ARMOR_BONUS_MODIFIER = new AttributeModifier(HIDING_ARMOR_BONUS_ID, "Hiding armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> GOO_AMOUNT = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> ACTION = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int hidingTime = 0;
    private float hideAmount;
    private float hideAmountO;
    private int shakeAmount;
    private int shakeAmountO;
    private boolean canBreed = true;
    private static final Predicate<LivingEntity> ENEMY_MATCHER = livingentity -> {
        if (livingentity == null) {
            return false;
        }
        livingentity.m_6844_(EquipmentSlot.CHEST);
        if (livingentity.m_6844_(EquipmentSlot.CHEST).m_41720_() == AutumnityItems.SNAIL_SHELL_CHESTPLATE.get()) {
            return false;
        }
        if (livingentity instanceof Player) {
            return !livingentity.m_6144_() && !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }
        return !(livingentity instanceof Snail) && !(livingentity instanceof MushroomCow);
    };

    public Snail(EntityType<? extends Snail> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HideGoal());
        this.f_21345_.m_25352_(1, (Goal)new EatGoal());
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.5, Ingredient.m_204132_(AutumnityItemTags.SNAIL_TEMPT_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new EatMushroomsGoal());
        this.f_21345_.m_25352_(5, (Goal)new EatMooshroomMushroomsGoal());
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GOO_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(ACTION, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("GooAmount", this.getGooAmount());
        compound.m_128405_("HidingTime", this.getHidingTime());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setGooAmount(compound.m_128451_("GooAmount"));
        this.setHidingTime(compound.m_128451_("HidingTime"));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AutumnityItems.SNAIL_SPAWN_EGG.get());
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_STEP.get(), 0.4f, 1.0f);
    }

    @Nullable
    public SoundEvent m_7866_(ItemStack itemStackIn) {
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.hideAmountO = this.hideAmount;
            this.hideAmount = this.getAction() == Action.HIDING ? Mth.m_14036_((float)(this.hideAmount + 1.0f), (float)0.0f, (float)3.0f) : Mth.m_14036_((float)(this.hideAmount - 0.5f), (float)0.0f, (float)3.0f);
            this.shakeAmountO = this.shakeAmount;
            this.shakeAmount = this.shakeAmount > 0 ? Mth.m_14045_((int)(this.shakeAmount - 1), (int)0, (int)20) : Mth.m_14045_((int)(this.shakeAmount + 1), (int)-20, (int)0);
        }
    }

    public void m_8107_() {
        if (this.getAction() != Action.DEFAULT || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
        if (this.getAction() == Action.EATING) {
            this.eat();
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            if (!this.m_21205_().m_41619_() && !this.hasSnack()) {
                this.spitOutItem();
            }
            if (this.getGooAmount() > 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                BlockState blockstate = ((Block)AutumnityBlocks.SNAIL_GOO.get()).m_49966_();
                BlockPos blockpos = this.m_20183_();
                if (this.getGooAmount() > 0 && this.m_9236_().m_46859_(blockpos) && blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos)) {
                    this.m_9236_().m_46597_(blockpos, blockstate);
                    this.setGooAmount(this.getGooAmount() - 1);
                }
            }
        }
    }

    public void eat() {
        if (this.f_19797_ % 12 == 0 && !this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            this.m_5496_((SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_EAT.get(), 0.25f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 6; ++i) {
                    Vec3 vector3d = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                    vector3d = vector3d.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                    vector3d = vector3d.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    double d0 = (double)(-this.f_19796_.m_188501_()) * 0.2;
                    Vec3 vector3d1 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.2, d0, 0.8 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.2);
                    vector3d1 = vector3d1.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                    vector3d1 = vector3d1.m_82520_(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_());
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_6844_(EquipmentSlot.MAINHAND)), vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, vector3d.f_82479_, vector3d.f_82480_ + 0.05, vector3d.f_82481_);
                }
            }
        }
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)AutumnityItems.SNAIL_SHELL_PIECE.get(), 1);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack;
        if (this.getAction() == Action.DEFAULT && !(itemstack = player.m_21120_(hand)).m_41619_() && !this.hasSnack()) {
            if (this.isSnack(itemstack)) {
                if (!this.m_6162_() && this.getGooAmount() <= 0) {
                    if (!this.m_9236_().f_46443_) {
                        ItemStack itemstack1 = itemstack.m_41777_();
                        itemstack1.m_41764_(1);
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                        AutumnityCriteriaTriggers.FEED_SNAIL.trigger((ServerPlayer)player, itemstack1);
                        this.m_142075_(player, hand, itemstack);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            } else if (this.isSnailBreedingItem(itemstack)) {
                boolean flag = false;
                if (!this.m_9236_().f_46443_ && this.m_146764_() == 0 && this.m_5957_()) {
                    this.m_27595_(player);
                    flag = true;
                } else if (this.m_6162_()) {
                    this.m_146740_((int)((float)(-this.m_146764_() / 20) * 0.1f), true);
                    flag = true;
                }
                if (flag) {
                    if (!this.m_9236_().f_46443_ && !player.m_150110_().f_35937_) {
                        ItemStack container = itemstack.getCraftingRemainingItem();
                        if (container.m_41619_() && itemstack.m_41720_() instanceof BowlFoodItem) {
                            container = new ItemStack((ItemLike)Items.f_42399_);
                        }
                        itemstack.m_41774_(1);
                        if (!container.m_41619_()) {
                            if (itemstack.m_41619_()) {
                                player.m_21008_(hand, container);
                            } else if (!player.m_150109_().m_36054_(container)) {
                                player.m_36176_(container, false);
                            }
                        }
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            }
        }
        this.canBreed = false;
        InteractionResult result = super.m_6071_(player, hand);
        this.canBreed = true;
        return result;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (this.getAction() == Action.HIDING && entity instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        this.spitOutItem();
        if (this.m_9236_().f_46443_) {
            this.shakeAmount = this.f_19796_.m_188503_(2) == 0 ? -10 : 10;
        }
        return super.m_6469_(source, amount);
    }

    private void spitOutItem() {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + (double)this.m_20192_(), this.m_20189_() + this.m_20154_().f_82481_, itemstack);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_9236_().m_7967_((Entity)itementity);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    private void eatSnack() {
        ItemStack itemstack = this.m_21205_();
        if (Ingredient.m_204132_(AutumnityItemTags.SNAIL_GLOW_SNACKS).test(itemstack)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
        }
        if (Ingredient.m_204132_(AutumnityItemTags.SNAIL_SPEED_SNACKS).test(itemstack)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 320, 2));
        }
        Item item = itemstack.m_41720_();
        ItemStack itemstack1 = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
        if (!itemstack1.m_41619_()) {
            if (itemstack1.m_41720_() != item) {
                this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                this.spitOutItem();
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
        this.setGooAmount(4);
    }

    private boolean hasSnack() {
        return this.isSnack(this.m_21205_());
    }

    private int getGooAmount() {
        return (Integer)this.f_19804_.m_135370_(GOO_AMOUNT);
    }

    private void setGooAmount(int amount) {
        this.f_19804_.m_135381_(GOO_AMOUNT, (Object)amount);
    }

    private int getHidingTime() {
        return this.hidingTime;
    }

    private void setHidingTime(int hidingTimeIn) {
        this.hidingTime = hidingTimeIn;
    }

    public Action getAction() {
        return Action.byId(((Byte)this.f_19804_.m_135370_(ACTION)).byteValue());
    }

    private void setAction(Action action) {
        this.f_19804_.m_135381_(ACTION, (Object)((byte)action.getId()));
        if (!this.m_9236_().f_46443_) {
            this.m_21051_(Attributes.f_22284_).m_22130_(HIDING_ARMOR_BONUS_MODIFIER);
            if (action == Action.HIDING) {
                this.m_21051_(Attributes.f_22284_).m_22118_(HIDING_ARMOR_BONUS_MODIFIER);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHideAmount(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.hideAmountO, (float)this.hideAmount) / 3.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAmount(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.shakeAmountO, (float)this.shakeAmount) / 20.0f;
    }

    private boolean isSnack(ItemStack stack) {
        return Ingredient.m_204132_(AutumnityItemTags.SNAIL_SNACKS).test(stack);
    }

    public boolean m_6898_(ItemStack stack) {
        return this.canBreed && this.isSnailBreedingItem(stack);
    }

    private boolean isSnailBreedingItem(ItemStack stack) {
        return Ingredient.m_204132_(AutumnityItemTags.SNAIL_FOOD).test(stack);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)AutumnityEntityTypes.SNAIL.get()).m_20615_((Level)world);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.6f;
    }

    public class HideGoal
    extends Goal {
        public HideGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Snail.this.getHidingTime() > 0 || Snail.this.m_21188_() != null || this.shouldHideFromMob();
        }

        public void m_8056_() {
            this.hide();
            Snail.this.m_21573_().m_26573_();
            Snail.this.m_21566_().m_6849_(Snail.this.m_20185_(), Snail.this.m_20186_(), Snail.this.m_20189_(), 0.0);
            Snail.this.setAction(Action.HIDING);
        }

        public void m_8041_() {
            Snail.this.setAction(Action.DEFAULT);
        }

        public void m_8037_() {
            if ((Snail.this.m_21188_() != null || this.shouldHideFromMob()) && Snail.this.getHidingTime() < 120) {
                this.hide();
            } else {
                Snail.this.setHidingTime(Snail.this.getHidingTime() - 1);
            }
        }

        public boolean m_8045_() {
            return Snail.this.getHidingTime() > 0;
        }

        private void hide() {
            Snail.this.setHidingTime(120 + Snail.this.f_19796_.m_188503_(120));
        }

        private boolean shouldHideFromMob() {
            for (LivingEntity livingentity : Snail.this.m_9236_().m_6443_(LivingEntity.class, Snail.this.m_20191_().m_82400_(0.5), ENEMY_MATCHER)) {
                if (!livingentity.m_6084_() || !(livingentity.m_20206_() > Snail.this.m_20206_())) continue;
                return true;
            }
            return false;
        }
    }

    class EatGoal
    extends Goal {
        private int eatTime;

        public EatGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Snail.this.hasSnack();
        }

        public void m_8056_() {
            this.eatTime = this.m_183277_(192);
            Snail.this.m_21573_().m_26573_();
            Snail.this.m_21566_().m_6849_(Snail.this.m_20185_(), Snail.this.m_20186_(), Snail.this.m_20189_(), 0.0);
            Snail.this.setAction(Action.EATING);
        }

        public void m_8041_() {
            Snail.this.setAction(Action.DEFAULT);
        }

        public void m_8037_() {
            --this.eatTime;
            if (this.eatTime <= 0) {
                Snail.this.eatSnack();
            }
        }

        public boolean m_8045_() {
            return Snail.this.hasSnack();
        }
    }

    class EatMushroomsGoal
    extends Goal {
        private double mushroomX;
        private double mushroomY;
        private double mushroomZ;

        public EatMushroomsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Snail.this.m_217043_().m_188503_(20) != 0) {
                return false;
            }
            return !Snail.this.m_6162_() && !Snail.this.hasSnack() && Snail.this.getGooAmount() <= 0 && ForgeEventFactory.getMobGriefingEvent((Level)Snail.this.m_9236_(), (Entity)Snail.this) && this.canMoveToMushroom();
        }

        public boolean m_8045_() {
            return !Snail.this.m_21573_().m_26571_() && !Snail.this.hasSnack() && Snail.this.getGooAmount() <= 0;
        }

        public void m_8056_() {
            Snail.this.m_21573_().m_26519_(this.mushroomX, this.mushroomY, this.mushroomZ, 0.5);
        }

        public void m_8037_() {
            BlockPos blockpos;
            if (!Snail.this.m_6162_() && Snail.this.getGooAmount() <= 0 && this.isBlockMushroom(blockpos = Snail.this.m_20183_()) && ForgeEventFactory.getMobGriefingEvent((Level)Snail.this.m_9236_(), (Entity)Snail.this)) {
                Snail.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Snail.this.m_9236_().m_8055_(blockpos).m_60734_().m_5456_(), 1));
                Snail.this.m_9236_().m_46961_(blockpos, false);
            }
        }

        @Nullable
        private Vec3 findMushroom() {
            RandomSource random = Snail.this.m_217043_();
            BlockPos blockpos = BlockPos.m_274561_((double)Snail.this.m_20185_(), (double)Snail.this.m_20191_().f_82289_, (double)Snail.this.m_20189_());
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(random.m_188503_(20) - 10, random.m_188503_(6) - 3, random.m_188503_(20) - 10);
                if (!this.isBlockMushroom(blockpos1)) continue;
                return new Vec3((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_());
            }
            return null;
        }

        private boolean canMoveToMushroom() {
            Vec3 vec3d = this.findMushroom();
            if (vec3d == null) {
                return false;
            }
            this.mushroomX = vec3d.f_82479_;
            this.mushroomY = vec3d.f_82480_;
            this.mushroomZ = vec3d.f_82481_;
            return true;
        }

        private boolean isBlockMushroom(BlockPos pos) {
            return Snail.this.m_9236_().m_8055_(pos).m_204336_(AutumnityBlockTags.SNAIL_SNACKS);
        }
    }

    public class EatMooshroomMushroomsGoal
    extends Goal {
        private MushroomCow targetMooshroom;
        private int timeToRecalcPath;

        public boolean m_8036_() {
            if (!Snail.this.m_6162_() && !Snail.this.hasSnack() && Snail.this.getGooAmount() <= 0) {
                List list = Snail.this.m_9236_().m_45976_(MushroomCow.class, Snail.this.m_20191_().m_82377_(8.0, 4.0, 8.0));
                MushroomCow mooshroom = null;
                double d0 = Double.MAX_VALUE;
                for (MushroomCow mooshroom1 : list) {
                    double d1;
                    if (mooshroom1.m_146764_() < 0 || (d1 = Snail.this.m_20280_((Entity)mooshroom1)) > d0) continue;
                    d0 = d1;
                    mooshroom = mooshroom1;
                }
                if (mooshroom == null) {
                    return false;
                }
                this.targetMooshroom = mooshroom;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!this.targetMooshroom.m_6084_()) {
                return false;
            }
            if (Snail.this.hasSnack()) {
                return false;
            }
            if (Snail.this.getGooAmount() > 0) {
                return false;
            }
            double d0 = this.targetMooshroom.m_20280_((Entity)Snail.this);
            return !(d0 > 256.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.targetMooshroom = null;
        }

        public void m_8037_() {
            double d0;
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                Snail.this.m_21573_().m_5624_((Entity)this.targetMooshroom, 0.5);
            }
            if (this.targetMooshroom != null && this.targetMooshroom.m_6084_() && (d0 = this.targetMooshroom.m_20280_((Entity)Snail.this)) < 2.0) {
                if (this.targetMooshroom.m_28554_() == MushroomCow.MushroomType.BROWN) {
                    Snail.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41952_, 1));
                } else {
                    Snail.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41953_, 1));
                }
                this.targetMooshroom.m_6469_(Snail.this.m_269291_().m_269333_((LivingEntity)Snail.this), 0.0f);
            }
        }
    }

    public static enum Action {
        DEFAULT(0),
        EATING(1),
        HIDING(2);

        private static final Action[] VALUES;
        private final int id;

        private Action(int idIn) {
            this.id = idIn;
        }

        public int getId() {
            return this.id;
        }

        public static Action byId(int indexIn) {
            if (indexIn < 0 || indexIn >= VALUES.length) {
                indexIn = 0;
            }
            return VALUES[indexIn];
        }

        static {
            VALUES = (Action[])Arrays.stream(Action.values()).sorted(Comparator.comparingInt(Action::getId)).toArray(Action[]::new);
        }
    }
}

