/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.autumnity.common.entity.animal.Snail;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailModel<T extends Snail>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart shell;
    private final ModelPart rightEye;
    private final ModelPart leftEye;
    private final ModelPart rightTentacle;
    private final ModelPart leftTentacle;
    private float hideAmount;

    public SnailModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.shell = root.m_171324_("shell");
        this.rightEye = root.m_171324_("right_eye");
        this.leftEye = root.m_171324_("left_eye");
        this.rightTentacle = root.m_171324_("right_tentacle");
        this.leftTentacle = root.m_171324_("left_tentacle");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-4.0f, 0.0f, 0.0f, 8.0f, 18.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)-9.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171506_(-4.5f, 0.0f, 0.0f, 9.0f, 14.0f, 14.0f, false), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)-1.0f, (float)-0.22f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171506_(-1.0f, -6.0f, -1.0f, 2.0f, 7.0f, 2.0f, false), PartPose.m_171423_((float)2.5f, (float)18.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171506_(-1.0f, -6.0f, -1.0f, 2.0f, 7.0f, 2.0f, true), PartPose.m_171423_((float)-2.5f, (float)18.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_tentacle", CubeListBuilder.m_171558_().m_171514_(28, 9).m_171506_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)3.0f, (float)22.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_tentacle", CubeListBuilder.m_171558_().m_171514_(28, 9).m_171506_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)-3.0f, (float)22.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.hideAmount = ((Snail)((Object)entity)).getHideAmount(partialTick);
        float f = 3.0f * this.hideAmount;
        float f1 = Mth.m_14036_((float)(10.0f * this.hideAmount), (float)0.0f, (float)5.0f);
        boolean flag = this.hideAmount < 1.0f;
        this.rightEye.m_104227_(2.5f, 18.0f + f1, -7.0f + f);
        this.leftEye.m_104227_(-2.5f, 18.0f + f1, -7.0f + f);
        this.rightTentacle.m_104227_(3.0f, 22.0f, -9.0f + f);
        this.leftTentacle.m_104227_(-3.0f, 22.0f, -9.0f + f);
        this.shell.m_104227_(0.0f, 7.0f, -1.0f - f);
        this.rightEye.f_104207_ = flag;
        this.leftEye.f_104207_ = flag;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f - this.hideAmount;
        float f1 = headPitch * ((float)Math.PI / 180) * 0.5f + 0.3f;
        float f2 = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
        float f3 = entity.m_19879_() % 2 == 0 ? 1.0f : 0.95f;
        float f4 = entity.m_19879_() % 2 == 0 ? 0.95f : 1.0f;
        this.rightEye.f_104203_ = f * (f1 + Mth.m_14089_((float)(0.04f * f3 * ageInTicks)) * 0.15f);
        this.rightEye.f_104204_ = f * f2;
        this.rightEye.f_104205_ = f * (0.25f + Mth.m_14031_((float)(0.025f * f3 * ageInTicks)) * 0.1f);
        this.leftEye.f_104203_ = f * (f1 + Mth.m_14031_((float)(0.04f * f4 * ageInTicks)) * 0.15f);
        this.leftEye.f_104204_ = f * f2;
        this.leftEye.f_104205_ = f * (-0.25f + Mth.m_14089_((float)(0.025f * f4 * ageInTicks)) * 0.1f);
        if (((Snail)((Object)entity)).getAction() == Snail.Action.EATING) {
            this.rightTentacle.f_104204_ = 0.25f * Mth.m_14089_((float)(0.6f * ageInTicks));
            this.leftTentacle.f_104204_ = -this.rightTentacle.f_104204_;
        } else {
            this.rightTentacle.f_104204_ = 0.0f;
            this.leftTentacle.f_104204_ = 0.0f;
        }
    }

    public void m_7695_(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
        if (this.f_102610_) {
            p_102034_.m_85836_();
            p_102034_.m_85841_(0.7f, 0.7f, 0.7f);
            p_102034_.m_85837_((double)0.075f, 0.8125, 0.15625);
            this.leftEye.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.m_85849_();
            p_102034_.m_85836_();
            p_102034_.m_85841_(0.7f, 0.7f, 0.7f);
            p_102034_.m_85837_((double)-0.075f, 0.8125, 0.15625);
            this.rightEye.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.m_85849_();
            p_102034_.m_85836_();
            p_102034_.m_85841_(0.5f, 0.5f, 0.5f);
            p_102034_.m_85837_(0.0, 1.5, 0.0);
            ImmutableList.of((Object)this.rightTentacle, (Object)this.leftTentacle, (Object)this.shell).forEach(p_103587_ -> p_103587_.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_));
            p_102034_.m_85836_();
            p_102034_.m_85841_(1.0f, 1.0f, 1.0f - 0.33333334f * this.hideAmount);
            this.body.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.m_85849_();
            p_102034_.m_85849_();
        } else {
            ImmutableList.of((Object)this.rightEye, (Object)this.leftEye).forEach(p_103587_ -> p_103587_.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_));
            ImmutableList.of((Object)this.rightTentacle, (Object)this.leftTentacle, (Object)this.shell).forEach(p_103587_ -> p_103587_.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_));
            p_102034_.m_85836_();
            p_102034_.m_85841_(1.0f, 1.0f, 1.0f - 0.33333334f * this.hideAmount);
            this.body.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.m_85849_();
        }
    }
}

