/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.orcinus.galosphere.api.BottlePickable;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.entities.ai.SpectreAi;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GNetworkHandler;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import org.jetbrains.annotations.Nullable;

public class Spectre
extends Animal
implements FlyingAnimal,
BottlePickable,
Spectatable {
    private static final EntityDataAccessor<Optional<UUID>> MANIPULATOR = SynchedEntityData.m_135353_(Spectre.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> CAN_BE_MANIPULATED = SynchedEntityData.m_135353_(Spectre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BOTTLE = SynchedEntityData.m_135353_(Spectre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Spectre>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_217824_, (Object)((SensorType)GSensorTypes.SPECTRE_TEMPTATIONS.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_217767_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_148197_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148198_, MemoryModuleType.f_217768_, (MemoryModuleType)GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get()});

    public Spectre(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    public float m_5610_(BlockPos p_27573_, LevelReader p_27574_) {
        return 0.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(GItemTags.SPECTRE_TEMPT_ITEMS);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)GEntityTypes.SPECTRE.get()).m_20615_((Level)serverLevel);
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        ServerPlayer serverPlayer = this.m_27592_();
        if (serverPlayer == null) {
            serverPlayer = animal.m_27592_();
        }
        if (serverPlayer != null) {
            serverPlayer.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(serverPlayer, (Animal)this, animal, null);
        }
        this.m_146762_(6000);
        animal.m_146762_(6000);
        this.m_27594_();
        animal.m_27594_();
        this.m_6274_().m_21879_(MemoryModuleType.f_217767_, (Object)Unit.INSTANCE);
        serverLevel.m_7605_((Entity)this, (byte)18);
        if (serverLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
            serverLevel.m_7967_((Entity)new ExperienceOrb((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MANIPULATOR, Optional.empty());
        this.f_19804_.m_135372_(CAN_BE_MANIPULATED, (Object)false);
        this.f_19804_.m_135372_(FROM_BOTTLE, (Object)false);
    }

    public static boolean checkSpectreSpawnRules(EntityType<? extends LivingEntity> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(GBlockTags.SPECTRES_SPAWNABLE_ON);
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        if (tag.m_128403_("Manipulator")) {
            uuid = tag.m_128342_("Manipulator");
        } else {
            String s = tag.m_128461_("Manipulator");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setManipulatorUUID(uuid);
        }
        this.setFromBottle(tag.m_128471_("FromBottle"));
        this.setCanBeManipulated(tag.m_128471_("CanBeManipulated"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getManipulatorUUID() != null) {
            tag.m_128362_("Manipulator", this.getManipulatorUUID());
        }
        tag.m_128379_("FromBottle", this.fromBottle());
        tag.m_128379_("CanBeManipulated", this.canBeManipulated());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)GSoundEvents.SPECTRE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)GSoundEvents.SPECTRE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)GSoundEvents.SPECTRE_DEATH.get();
    }

    @Override
    @Nullable
    public UUID getManipulatorUUID() {
        return ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).orElse(null);
    }

    @Override
    public void setManipulatorUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(MANIPULATOR, Optional.ofNullable(uuid));
    }

    @Override
    public void spectateTick(UUID uuid) {
        Player player = this.m_9236_().m_46003_(uuid);
        if (player != null) {
            player.f_20900_ = 0.0f;
            player.f_20902_ = 0.0f;
            player.m_6862_(false);
            if (!player.m_150108_() || this.m_21224_()) {
                this.setManipulatorUUID(null);
                if (this.m_9236_().f_46443_) {
                    this.stopUsingSpyglass(player);
                } else {
                    ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(false);
                    player.m_6330_((SoundEvent)GSoundEvents.SPECTRE_MANIPULATE_END.get(), this.m_5720_(), 1.0f, 1.0f);
                }
            }
        }
        if (!this.m_9236_().m_5776_() && player == null) {
            this.f_19804_.m_135381_(MANIPULATOR, Optional.empty());
        }
    }

    public boolean canBeManipulated() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BE_MANIPULATED);
    }

    public void setCanBeManipulated(boolean canBeManipulated) {
        this.f_19804_.m_135381_(CAN_BE_MANIPULATED, (Object)canBeManipulated);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(true);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.canBeManipulated() && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFluidParticle(this.m_9236_(), this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)GParticleTypes.ALLURITE_RAIN.get());
            }
        }
    }

    private void spawnFluidParticle(Level world, double minX, double maxX, double minZ, double maxZ, double y, ParticleOptions options) {
        world.m_7106_(options, Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)minX, (double)maxX), y, Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    protected boolean m_142039_() {
        return this.m_29443_();
    }

    protected Brain.Provider<Spectre> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return SpectreAi.makeBrain((Brain<Spectre>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Spectre> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("spectreBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("spectreActivityUpdate");
        SpectreAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() || this.matchesClientPlayerUUID()) {
            ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).ifPresent(this::spectateTick);
        }
    }

    public boolean m_6785_(double d) {
        return !this.m_8077_() && !this.fromBottle();
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromBottle();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopUsingSpyglass(Player player) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == player) {
            client.m_91118_((Entity)player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean matchesClientPlayerUUID() {
        return Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20148_().equals(this.getManipulatorUUID());
    }

    public void m_7023_(Vec3 velocity) {
        if (this.getManipulatorUUID() != null) {
            ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).map(arg_0 -> ((Level)this.m_9236_()).m_46003_(arg_0)).ifPresent(uuid -> this.copyPlayerRotation((LivingEntity)this, (Player)uuid));
        } else {
            super.m_7023_(velocity);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (this.canBeManipulated() && (stack.m_150930_((Item)GItems.SPECTRE_BOUND_SPYGLASS.get()) || stack.m_150930_(Items.f_151059_))) {
            this.m_5496_((SoundEvent)GSoundEvents.SPECTRE_LOCK_TO_SPYGLASS.get(), 1.0f, 1.0f);
            ItemStack spectreBoundedSpyglass = new ItemStack((ItemLike)GItems.SPECTRE_BOUND_SPYGLASS.get());
            if (this.m_8077_()) {
                spectreBoundedSpyglass.m_41714_(this.m_7770_());
            }
            SpectreBoundSpyglass.addSpectreBoundedTags(this, spectreBoundedSpyglass.m_41784_());
            player.m_21008_(interactionHand, spectreBoundedSpyglass);
            this.setCanBeManipulated(false);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42590_)) {
            this.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)GSoundEvents.SPECTRE_BOTTLE_FILL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!this.m_9236_().m_5776_()) {
                this.m_146850_(GameEvent.f_223708_);
                ItemStack itemStack2 = new ItemStack((ItemLike)GItems.BOTTLE_OF_SPECTRE.get());
                CompoundTag compoundTag = new CompoundTag();
                this.m_20223_(compoundTag);
                itemStack2.m_41751_(compoundTag);
                player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)itemStack2));
                this.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)GItems.ALLURITE_SHARD.get()) && this.getManipulatorUUID() == null && !this.canBeManipulated()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setCanBeManipulated(true);
            this.m_5496_((SoundEvent)GSoundEvents.SPECTRE_RECEIVE_ITEM.get(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public void setCamera(Player player) {
        if (!this.m_9236_().m_5776_()) {
            player.f_20902_ = 0.0f;
            ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(true);
            this.setManipulatorUUID(player.m_20148_());
            GNetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SendPerspectivePacket(player.m_20148_(), this.m_19879_()));
            this.m_5496_((SoundEvent)GSoundEvents.SPECTRE_MANIPULATE_BEGIN.get(), 1.0f, 1.0f);
        }
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    @Override
    public boolean fromBottle() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOTTLE);
    }

    @Override
    public void setFromBottle(boolean fromBottle) {
        this.f_19804_.m_135381_(FROM_BOTTLE, (Object)fromBottle);
    }
}

