/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GEntityTypes;

public class CordycepsBlockEntity
extends BlockEntity {
    private int growthTick;
    private int delay = 0;

    public CordycepsBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)GBlockEntityTypes.CORDYCEPS.get(), blockPos, blockState);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, CordycepsBlockEntity te) {
        if (!((Boolean)state.m_61143_((Property)CordycepsBlock.ALIVE)).booleanValue()) {
            return;
        }
        int stage = (Integer)state.m_61143_((Property)CordycepsBlock.ALIVE_STAGE);
        int delay = te.getDelay();
        if (te.getGrowthTick() == 6000) {
            Optional.ofNullable((Spectre)((EntityType)GEntityTypes.SPECTRE.get()).m_20615_(world)).ifPresent(spectre -> te.spawnSpectre(world, pos, (Spectre)spectre));
        }
        if (delay > 0) {
            te.setDelay(delay - 1);
        }
        if (stage < 5 && delay == 0) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
            te.setDelay(20);
        }
        if (stage == 5) {
            te.setDelay(0);
            if (te.getGrowthTick() < 6000) {
                if (te.getGrowthTick() > 5000) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)CordycepsBlock.BULB, (Comparable)Boolean.valueOf(true)), 2);
                }
                te.setGrowthTick(te.getGrowthTick() + 1);
            }
        }
    }

    private void spawnSpectre(Level world, BlockPos pos, Spectre spectre) {
        spectre.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
        spectre.m_21530_();
        world.m_7967_((Entity)spectre);
        world.m_46961_(pos, true);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setGrowthTick(int growthTick) {
        this.growthTick = growthTick;
    }

    public int getGrowthTick() {
        return this.growthTick;
    }
}

