/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.EnumUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.EntitySnowLayerBlock;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowFenceGateBlock;
import snownee.snow.block.SnowSlabBlock;
import snownee.snow.block.SnowStairsBlock;
import snownee.snow.block.SnowWallBlock;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.block.entity.SnowCoveredBlockEntity;
import snownee.snow.entity.FallingSnowEntity;
import snownee.snow.loot.NormalizeLoot;
import snownee.snow.mixin.BlockAccess;

@KiwiModule
public class CoreModule
extends AbstractModule {
    public static final TagKey<Block> SNOWY_SETTING = CoreModule.blockTag((String)"snowrealmagic", (String)"snowy_setting");
    public static final TagKey<Block> CONTAINABLES = CoreModule.blockTag((String)"snowrealmagic", (String)"containables");
    public static final TagKey<Block> NOT_CONTAINABLES = CoreModule.blockTag((String)"snowrealmagic", (String)"not_containables");
    public static final TagKey<Block> OFFSET_Y = CoreModule.blockTag((String)"snowrealmagic", (String)"offset_y");
    public static final TagKey<Block> CANNOT_ACCUMULATE_ON = CoreModule.blockTag((String)"snowrealmagic", (String)"cannot_accumulate_on");
    @KiwiModule.NoItem
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<EntitySnowLayerBlock> TILE_BLOCK = CoreModule.go(() -> new EntitySnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50125_).m_60988_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> FENCE = CoreModule.go(() -> new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50132_).m_284180_(MapColor.f_283811_).m_60918_(SoundType.f_56747_).m_60977_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> FENCE2 = CoreModule.go(() -> new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50198_).m_284180_(MapColor.f_283811_).m_60918_(SoundType.f_56747_).m_60977_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> STAIRS = CoreModule.go(() -> new SnowStairsBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50086_).m_284180_(MapColor.f_283811_).m_60918_(SoundType.f_56747_).m_60977_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> SLAB = CoreModule.go(() -> new SnowSlabBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50398_).m_284180_(MapColor.f_283811_).m_60918_(SoundType.f_56747_).m_60977_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> FENCE_GATE = CoreModule.go(() -> new SnowFenceGateBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50192_).m_284180_(MapColor.f_283811_).m_60918_(SoundType.f_56747_).m_60977_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> WALL = CoreModule.go(() -> new SnowWallBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50274_).m_284180_(MapColor.f_283811_).m_60918_(SoundType.f_56747_).m_60977_()));
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<BlockEntityType<SnowBlockEntity>> TILE = CoreModule.blockEntity(SnowBlockEntity::new, null, (Supplier[])new Supplier[]{TILE_BLOCK});
    public static final KiwiGO<BlockEntityType<SnowCoveredBlockEntity>> TEXTURE_TILE = CoreModule.blockEntity(SnowCoveredBlockEntity::new, null, (Supplier[])new Supplier[]{FENCE, FENCE2, STAIRS, SLAB, FENCE_GATE, WALL});
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<EntityType<FallingSnowEntity>> ENTITY = CoreModule.go(() -> EntityType.Builder.m_20704_(FallingSnowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory((spawnEntity, world) -> new FallingSnowEntity((Level)world)).m_20699_(0.98f, 0.001f).m_20702_(10).m_20717_(20).m_20712_("snowrealmagic.snow"));
    public static final KiwiGO<LootPoolEntryType> NORMALIZE = CoreModule.go(() -> new LootPoolEntryType((Serializer)new NormalizeLoot.Serializer()));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_STRENGTH = GameRules.m_46189_((String)"snowrealmagic:blizzardStrength", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)0));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_FREQUENCY = GameRules.m_46189_((String)"snowrealmagic:blizzardFrequency", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)10000));

    public CoreModule() {
        this.decorators.remove(ForgeRegistries.BLOCKS);
    }

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            BlockBehaviour.StateArgumentPredicate predicate = (blockState, blockGetter, blockPos, entityType) -> {
                BlockPos below = blockPos.m_7495_();
                return (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61417_) <= SnowCommonConfig.mobSpawningMaxLayers && blockGetter.m_8055_(below).m_60643_(blockGetter, below, entityType);
            };
            ((BlockAccess)Blocks.f_50125_).getProperties().m_60922_(predicate);
            ((BlockAccess)TILE_BLOCK.get()).getProperties().m_60922_(predicate);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(ClientInitEvent event) {
        Predicate<RenderType> blockRenderTypes = EnumUtil.BLOCK_RENDER_TYPES::contains;
        for (Supplier supplier : List.of(TILE_BLOCK, FENCE, FENCE2, FENCE_GATE, SLAB, STAIRS, WALL)) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)supplier.get()), blockRenderTypes);
        }
    }
}

