/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.mod.item.BlockStateRenderingData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemIconWithBlockState
extends ItemIcon {
    public static final String PARAM_NBT = "nbt";
    @Nullable
    protected BlockStateRenderingData blockStateExtension = null;
    protected boolean renderItemAlongBlockState = false;
    protected boolean isBlockStateModelEmpty = false;
    protected boolean alwaysAddBlockStateTooltip = false;

    public ItemIconWithBlockState() {
    }

    public ItemIconWithBlockState(PaneParams params) {
        super(params);
        ItemStack newItemStack = this.itemStack;
        if (newItemStack != null) {
            String nbt = params.getString(PARAM_NBT);
            if (nbt != null) {
                try {
                    newItemStack.m_41751_(TagParser.m_129359_((String)nbt));
                }
                catch (CommandSyntaxException e) {
                    Log.getLogger().error("Cannot parse item nbt", (Throwable)e);
                }
            }
            this.setItem(newItemStack);
        }
        this.alwaysAddBlockStateTooltip = params.getBoolean("alwaysAddBlockStateTooltip", this.alwaysAddBlockStateTooltip);
    }

    @Override
    public void setItem(ItemStack itemStack) {
        super.setItem(itemStack);
        this.readBlockStateFromCurrentItemStack();
    }

    @Override
    public void clearDataAndScheduleTooltipUpdate() {
        super.clearDataAndScheduleTooltipUpdate();
        this.blockStateExtension = null;
        this.renderItemAlongBlockState = false;
        this.isBlockStateModelEmpty = false;
    }

    public boolean isBlockEmpty() {
        return this.blockStateExtension == null || this.isBlockStateModelEmpty;
    }

    @Override
    public boolean isDataEmpty() {
        return super.isDataEmpty() && this.isBlockEmpty();
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        this.updateTooltipIfNeeded();
        if (this.isBlockEmpty()) {
            super.drawSelf(target, mx, my);
            return;
        }
        PoseStack ms = target.m_280168_();
        ms.m_85836_();
        ms.m_252880_((float)this.x, (float)this.y, 0.0f);
        ms.m_85841_((float)this.getWidth() / 16.0f, (float)this.getHeight() / 16.0f, 1.0f);
        if (this.renderItemAlongBlockState) {
            target.m_280480_(this.itemStack, 0, 0);
        }
        target.renderBlockStateAsItem(this.blockStateExtension, this.itemStack);
        if (this.renderItemDecorations) {
            target.renderItemDecorations(this.itemStack, 0, 0);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        ms.m_85849_();
    }

    @Override
    protected int modifyTooltipName(List<Component> tooltipList, TooltipFlag tooltipFlag, int nameOffset) {
        if (this.blockStateExtension != null) {
            ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)this.blockStateExtension.blockState().m_60734_());
            String nameTKey = Util.m_137492_((String)"block", (ResourceLocation)key);
            MutableComponent name = Component.m_237115_((String)nameTKey);
            MutableComponent nameKey = Component.m_237113_((String)key.toString()).m_130940_(ChatFormatting.DARK_GRAY);
            if (!tooltipList.get(0).getString().equals(name.getString()) && !name.getString().equals(nameTKey)) {
                tooltipList.add(nameOffset, (Component)name.m_130940_(ChatFormatting.GRAY));
                ++nameOffset;
            }
            for (int i = tooltipList.size() - 1; i >= 0; --i) {
                LiteralContents literalContents;
                ComponentContents componentContents = tooltipList.get(i).m_214077_();
                if (!(componentContents instanceof LiteralContents) || !ResourceLocation.m_135830_((String)(literalContents = (LiteralContents)componentContents).f_237368_())) continue;
                tooltipList.set(i, (Component)nameKey);
                break;
            }
        }
        return nameOffset;
    }

    @Override
    protected int appendTooltip(List<Component> tooltipList, TooltipFlag tooltipFlag, int prevTooltipSize) {
        if (this.blockStateExtension != null && !this.blockStateExtension.blockState().m_61147_().isEmpty() && (tooltipFlag.m_7050_() || this.alwaysAddBlockStateTooltip)) {
            boolean shouldFixPrevTooltipSize = this.alwaysAddBlockStateTooltip && prevTooltipSize == tooltipList.size();
            tooltipList.add((Component)ItemIconWithBlockState.wrapShift(Component.m_237119_(), !this.alwaysAddBlockStateTooltip));
            tooltipList.add((Component)ItemIconWithBlockState.wrapShift(Component.m_237115_((String)"blockui.tooltip.properties"), !this.alwaysAddBlockStateTooltip));
            BlockState blockState = this.blockStateExtension.blockState();
            for (Property property : blockState.m_61147_()) {
                tooltipList.add((Component)ItemIconWithBlockState.wrapShift(Component.m_237113_((String)("  " + property.m_61708_() + " = " + ItemIconWithBlockState.getValueName(blockState, property))).m_130940_(ChatFormatting.GRAY), !this.alwaysAddBlockStateTooltip));
            }
            if (shouldFixPrevTooltipSize) {
                prevTooltipSize = tooltipList.size();
            }
        }
        return prevTooltipSize;
    }

    public void setRenderItemAlongBlockState(boolean alwaysRenderItem) {
        this.renderItemAlongBlockState = alwaysRenderItem;
    }

    public boolean shouldRenderItemAlongBlockState() {
        return this.renderItemAlongBlockState;
    }

    public void setAlwaysAddBlockStateTooltip(boolean alwaysAddTooltip) {
        this.alwaysAddBlockStateTooltip = alwaysAddTooltip;
    }

    public boolean shouldAlwaysAddBlockStateTooltip() {
        return this.alwaysAddBlockStateTooltip;
    }

    public void setBlockState(BlockState blockState, @Nullable BlockEntity blockEntity) {
        this.setBlockState(BlockStateRenderingData.of(blockState, blockEntity));
    }

    public void setBlockState(BlockStateRenderingData blockStateExtension) {
        this.setItemFromBlockState(blockStateExtension);
        this.setBlockStateWeak(blockStateExtension);
    }

    public void setBlockStateWeak(BlockStateRenderingData blockStateExtension) {
        ItemStack keepItemStack = Objects.requireNonNull(this.itemStack, "ItemStack must not be null when setting blockState");
        this.clearDataAndScheduleTooltipUpdate();
        this.itemStack = keepItemStack;
        this.blockStateExtension = blockStateExtension;
        BlockState bs = blockStateExtension.blockState();
        if (bs.m_60799_() == RenderShape.INVISIBLE && blockStateExtension.blockEntity() == null) {
            if (bs.m_60819_().m_76178_()) {
                this.isBlockStateModelEmpty = true;
            } else if (bs.m_61138_((Property)BlockStateProperties.f_61362_)) {
                this.renderItemAlongBlockState = true;
            }
        }
    }

    public BlockStateRenderingData getBlockState() {
        return this.blockStateExtension;
    }

    protected void readBlockStateFromCurrentItemStack() {
        Item item;
        if (this.itemStack == null || !((item = this.itemStack.m_41720_()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState blockstate = blockItem.m_40614_().m_49966_();
        CompoundTag blockStateTag = this.itemStack.m_41737_("BlockStateTag");
        if (blockStateTag == null) {
            return;
        }
        StateDefinition statedefinition = blockstate.m_60734_().m_49965_();
        for (String propertyKey : blockStateTag.m_128431_()) {
            Property property = statedefinition.m_61081_(propertyKey);
            if (property == null) continue;
            blockstate = ItemIconWithBlockState.updateState(blockstate, property, blockStateTag.m_128461_(propertyKey));
        }
        CompoundTag blockEntityTag = this.itemStack.m_41737_("BlockEntityTag");
        BlockEntity be = null;
        if (blockEntityTag != null) {
            try {
                be = BlockEntity.m_155241_((BlockPos)BlockStateRenderingData.ILLEGAL_BLOCK_ENTITY_POS, (BlockState)blockstate, (CompoundTag)blockEntityTag);
            }
            catch (Exception e) {
                Log.getLogger().warn("Error while parsing blockentity data: " + String.valueOf(blockEntityTag), (Throwable)e);
            }
        }
        this.setBlockStateWeak(BlockStateRenderingData.of(blockstate, be));
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String valueName) {
        return property.m_6215_(valueName).map(value -> (BlockState)state.m_61124_(property, value)).orElse(state);
    }

    private static <T extends Comparable<T>> String getValueName(BlockState blockState, Property<T> property) {
        return property.m_6940_(blockState.m_61143_(property));
    }
}

