/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.network.messages.BlueprintSyncMessage;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ClientBlueprintRequestMessage
implements IMessage {
    public final BuildToolPlacementMessage.HandlerType type;
    public final String handlerId;
    public final String structurePackId;
    public final String blueprintPath;
    public final BlockPos pos;
    public final Rotation rotation;
    public final Mirror mirror;

    public ClientBlueprintRequestMessage(FriendlyByteBuf buf) {
        this.type = BuildToolPlacementMessage.HandlerType.values()[buf.readInt()];
        this.handlerId = buf.m_130136_(Short.MAX_VALUE);
        this.structurePackId = buf.m_130136_(Short.MAX_VALUE);
        this.blueprintPath = buf.m_130136_(Short.MAX_VALUE);
        this.pos = buf.m_130135_();
        this.rotation = Rotation.values()[buf.readInt()];
        this.mirror = Mirror.values()[buf.readInt()];
    }

    public ClientBlueprintRequestMessage(BuildToolPlacementMessage msg) {
        this.type = msg.type;
        this.handlerId = msg.handlerId;
        this.structurePackId = msg.structurePackId;
        this.blueprintPath = msg.blueprintPath;
        this.pos = msg.pos;
        this.rotation = msg.rotation;
        this.mirror = msg.mirror;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.m_130070_(this.handlerId);
        buf.m_130070_(this.structurePackId);
        buf.m_130070_(this.blueprintPath);
        buf.m_130064_(this.pos);
        buf.writeInt(this.rotation.ordinal());
        buf.writeInt(this.mirror.ordinal());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientFutureProcessor.queueBlueprintData(new ClientFutureProcessor.BlueprintDataProcessingData(StructurePacks.getBlueprintDataFuture(this.structurePackId, this.blueprintPath), blueprintData -> {
            if (blueprintData != null) {
                Network.getNetwork().sendToServer(new BlueprintSyncMessage(this, (byte[])blueprintData));
            }
        }));
    }
}

