/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blocks.interfaces.IInvisibleBlueprintAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlueprintTagUtils {
    public static Map<BlockPos, List<String>> getBlueprintTags(Blueprint blueprint) {
        BlockPos anchorPos = blueprint.getPrimaryBlockOffset();
        CompoundTag nbt = blueprint.getBlockInfoAsMap().get(anchorPos).getTileEntityData();
        if (nbt != null) {
            return IBlueprintDataProviderBE.readTagPosMapFrom(nbt.m_128469_("blueprintDataProvider"));
        }
        return new HashMap<BlockPos, List<String>>();
    }

    public static boolean isInvisible(Blueprint blueprint) {
        IInvisibleBlueprintAnchorBlock invis;
        BlockInfo anchor = blueprint.getBlockInfoAsMap().get(blueprint.getPrimaryBlockOffset());
        Block block = anchor.getState().m_60734_();
        if (block instanceof IInvisibleBlueprintAnchorBlock && !(invis = (IInvisibleBlueprintAnchorBlock)block).isVisible(anchor.getTileEntityData())) {
            return true;
        }
        List anchorTags = BlueprintTagUtils.getBlueprintTags(blueprint).computeIfAbsent(BlockPos.f_121853_, k -> new ArrayList());
        return anchorTags.contains("invisible");
    }

    @Nullable
    public static BlockPos getFirstPosForTag(Blueprint blueprint, String tagName) {
        Map<BlockPos, List<String>> tagPosMap = BlueprintTagUtils.getBlueprintTags(blueprint);
        for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
            for (String tag : entry.getValue()) {
                if (!tag.equals(tagName)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static int getNumberOfGroundLevels(@NotNull Blueprint blueprint, int defaultGroundLevels) {
        BlockPos groundLevelPos = BlueprintTagUtils.getFirstPosForTag(blueprint, "groundlevel");
        if (groundLevelPos != null) {
            return blueprint.getPrimaryBlockOffset().m_123342_() + groundLevelPos.m_123342_() + 1;
        }
        return defaultGroundLevels;
    }

    public static int getGroundAnchorOffset(@NotNull Blueprint blueprint, int defaultGroundOffset) {
        BlockPos groundLevelPos = BlueprintTagUtils.getFirstPosForTag(blueprint, "groundlevel");
        if (groundLevelPos != null) {
            return -groundLevelPos.m_123342_();
        }
        return defaultGroundOffset;
    }

    public static int getGroundAnchorOffsetFromGroundLevels(@NotNull Blueprint blueprint, int groundLevels) {
        return blueprint.getPrimaryBlockOffset().m_123342_() - groundLevels + 1;
    }
}

