/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.carpeted;

import java.util.function.Supplier;
import net.mehvahdjukaar.carpeted.CarpetSlabBlock;
import net.mehvahdjukaar.carpeted.CarpetStairBlock;
import net.mehvahdjukaar.carpeted.CarpetedBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Carpeted {
    public static final String MOD_ID = "carpeted";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Supplier<Block> CARPET_STAIRS = RegHelper.registerBlock((ResourceLocation)Carpeted.res("carpet_stairs"), () -> new CarpetStairBlock(Blocks.f_50086_));
    public static final Supplier<Block> CARPET_SLAB = RegHelper.registerBlock((ResourceLocation)Carpeted.res("carpet_slab"), () -> new CarpetSlabBlock(Blocks.f_50398_));
    public static final Supplier<BlockEntityType<CarpetedBlockTile>> CARPET_STAIRS_TILE = RegHelper.registerBlockEntityType((ResourceLocation)Carpeted.res("carpeted_block"), () -> PlatHelper.newBlockEntityType(CarpetedBlockTile::new, (Block[])new Block[]{CARPET_STAIRS.get(), CARPET_SLAB.get()}));

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos;
        BlockState state;
        BlockState replacingBlock;
        BlockItem bi;
        Item item;
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_150110_().f_35938_ && (item = stack.m_41720_()) instanceof BlockItem && (bi = (BlockItem)item).m_40614_() instanceof CarpetBlock && (replacingBlock = Carpeted.getReplacingBlock(state = level.m_8055_(pos = hitResult.m_82425_()))) != null) {
            level.m_46597_(pos, replacingBlock);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CarpetedBlockTile) {
                CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
                BlockState carpet = bi.m_40614_().m_49966_();
                tile.initialize(state, carpet);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10591_.m_285767_(serverPlayer, pos, stack);
                }
                level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
                SoundType sound = carpet.m_60827_();
                level.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static BlockState getReplacingBlock(BlockState state) {
        Block b = state.m_60734_();
        if (!(b instanceof EntityBlock)) {
            if (b instanceof StairBlock && state.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM) {
                return CARPET_STAIRS.get().m_152465_(state);
            }
            if (b instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
                return CARPET_SLAB.get().m_152465_(state);
            }
        }
        return null;
    }
}

