/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.carpeted;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import net.mehvahdjukaar.carpeted.Carpeted;
import net.mehvahdjukaar.carpeted.CarpetedBlockTile;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CarpetSlabBlock
extends SlabBlock
implements EntityBlock {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light_level", (int)0, (int)15);
    public static final BooleanProperty SOLID = BooleanProperty.m_61465_((String)"solid");
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public CarpetSlabBlock(Block block) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_60953_(state -> Math.max(0, (Integer)state.m_61143_((Property)LIGHT_LEVEL))));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BOTTOM_AABB;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)SOLID) != false ? super.m_7952_(state, level, pos) : Shapes.m_83040_();
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        IBlockHolder tile;
        BlockState mimicState;
        super.m_142387_(level, player, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock(1)).m_60795_()) {
            SoundType sound = mimicState.m_60827_();
            level.m_5594_(null, pos, sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, this.f_60446_.m_56774_() * 0.8f);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHT_LEVEL, SOLID});
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).m_60795_() && !(mimicState.m_60734_() instanceof CarpetSlabBlock)) {
            return mimicState.m_60625_(player, worldIn, pos);
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    @PlatformOnly(value={"forge"})
    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).m_60795_()) {
            return mimicState.m_60827_();
        }
        return super.m_49962_(state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)object;
            BlockState heldState = tile.getHeldBlock(0);
            BlockState carpet = tile.getHeldBlock(1);
            Object object2 = builder.m_287159_(LootContextParams.f_81455_);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (ForgeHelper.canHarvestBlock((BlockState)heldState, (ServerLevel)builder.m_287258_(), (BlockPos)BlockPos.m_274446_((Position)((Position)builder.m_287261_(LootContextParams.f_81460_))), (ServerPlayer)player)) {
                    drops.addAll(heldState.m_287290_(builder));
                }
            }
            drops.addAll(carpet.m_287290_(builder));
        }
        return drops;
    }

    @PlatformOnly(value={"forge"})
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CarpetedBlockTile) {
            BlockHitResult hs;
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            if (target instanceof BlockHitResult && (hs = (BlockHitResult)target).m_82434_() == Direction.UP) {
                return tile.getHeldBlock(1).m_60734_().m_7397_(level, pos, state);
            }
            BlockState mimic = tile.getHeldBlock();
            return mimic.m_60734_().m_7397_(level, pos, state);
        }
        return super.m_7397_(level, pos, state);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.m_60734_().m_7397_(level, pos, state);
        }
        return super.m_7397_(level, pos, state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CarpetedBlockTile(pPos, pState);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
        BlockEntity blockEntity = world.m_7702_(currentPos);
        if (blockEntity instanceof CarpetedBlockTile) {
            BlockEntity blockEntity2;
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState oldHeld = tile.getHeldBlock();
            CarpetedBlockTile otherTile = null;
            if (facingState.m_60713_(Carpeted.CARPET_STAIRS.get()) && (blockEntity2 = world.m_7702_(facingPos)) instanceof CarpetedBlockTile) {
                CarpetedBlockTile te2;
                otherTile = te2 = (CarpetedBlockTile)blockEntity2;
                facingState = otherTile.getHeldBlock();
            }
            BlockState newHeld = oldHeld.m_60728_(facing, facingState, world, currentPos, facingPos);
            BlockState newFacing = facingState.m_60728_(facing.m_122424_(), newHeld, world, facingPos, currentPos);
            if (newFacing != facingState) {
                if (otherTile != null) {
                    otherTile.setHeldBlock(newFacing);
                    otherTile.m_6596_();
                } else {
                    world.m_7731_(facingPos, newFacing, 2);
                }
            }
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
            }
        }
        return newState;
    }
}

